/*
 * Decompiled with CFR 0.152.
 */
package com.ijz.framework.export.excel.imports.definition;

import com.ijz.framework.export.excel.imports.definition.ColumnDefinition;
import com.ijz.framework.export.exception.ImportException;
import com.ijz.framework.export.utils.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

public class ImportDefinition<T> {
    private String sheetName;
    private int startIndex;
    private Class<T> modelClass;
    private List<ColumnDefinition> columns;
    private boolean parallel;
    private int threadNumber;

    private ImportDefinition(Builder<T> builder) {
        this.sheetName = ((Builder)builder).sheetName;
        this.startIndex = ((Builder)builder).startIndex;
        this.modelClass = ((Builder)builder).modelClass;
        this.columns = ((Builder)builder).columns;
        this.parallel = ((Builder)builder).parallel;
        this.threadNumber = ((Builder)builder).threadNumber;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public Class<T> getModelClass() {
        return this.modelClass;
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public int getThreadNumber() {
        return this.threadNumber;
    }

    public static class Builder<T> {
        private String sheetName;
        private int startIndex = 1;
        private Class<T> modelClass;
        private List<ColumnDefinition> columns;
        private boolean parallel;
        private int threadNumber = Runtime.getRuntime().availableProcessors();

        public Builder<T> sheetName(String sheetName) {
            this.sheetName = sheetName;
            return this;
        }

        public Builder<T> startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder<T> modelClass(Class<T> modelClass) {
            this.modelClass = modelClass;
            return this;
        }

        public Builder<T> columns(List<ColumnDefinition> columns) {
            this.columns = columns;
            return this;
        }

        public Builder<T> parallel(boolean parallel) {
            this.parallel = parallel;
            return this;
        }

        public Builder<T> threadNumber(int threadNumber) {
            this.threadNumber = threadNumber;
            return this;
        }

        public Builder<T> simpleColumns(List<String> columns) {
            this.columns = columns.stream().map(item -> new ColumnDefinition.Builder().name((String)item).build()).collect(Collectors.toList());
            return this;
        }

        public ImportDefinition<T> build() {
            if (this.modelClass == null) {
                throw new ImportException("\u672a\u6307\u5b9amodelClass");
            }
            if (CollectionUtils.isEmpty(this.columns)) {
                throw new ImportException("columns\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return new ImportDefinition(this);
        }
    }
}

