/*
 * Decompiled with CFR 0.152.
 */
package com.ijz.framework.export.excel.imports.valuefunction;

import com.ijz.framework.export.exception.ImportException;
import com.ijz.framework.export.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Function;

public class DateImportFunction
implements Function<String, Date> {
    private String format;

    public DateImportFunction() {
        this("yyyy-MM-dd");
    }

    public DateImportFunction(String format) {
        this.format = format;
    }

    @Override
    public Date apply(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        try {
            return new SimpleDateFormat(this.format).parse(value);
        }
        catch (ParseException e) {
            throw new ImportException(String.format("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff1a%s", value), e);
        }
    }
}

