/*
 * Decompiled with CFR 0.152.
 */
package com.ijz.framework.export.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ReflectUtils {
    public static List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return fields;
    }

    public static Object getFieldValueWithAnnotation(Object obj, Class<? extends Annotation> annotationClass) {
        Class<?> clazz = obj.getClass();
        Optional<Field> optional = ReflectUtils.getAllDeclaredFields(clazz).stream().filter(field -> field.isAnnotationPresent(annotationClass)).findFirst();
        if (optional.isPresent()) {
            Field field2 = optional.get();
            field2.setAccessible(true);
            try {
                return field2.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("\u8bfb\u53d6\u5bf9\u8c61\uff1a%s\u5b57\u6bb5\uff1a%s\u5f02\u5e38", clazz.getSimpleName(), field2.getName()), e);
            }
        }
        return null;
    }

    public static Object getFieldValueWithName(Object obj, String fieldName) {
        Class<?> clazz = obj.getClass();
        Optional<Field> optional = ReflectUtils.getAllDeclaredFields(clazz).stream().filter(field -> field.getName().equals(fieldName)).findFirst();
        if (optional.isPresent()) {
            Field field2 = optional.get();
            field2.setAccessible(true);
            try {
                return field2.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("\u8bfb\u53d6\u5bf9\u8c61\uff1a%s\u5b57\u6bb5\uff1a%s\u5f02\u5e38", clazz.getSimpleName(), field2.getName()), e);
            }
        }
        return null;
    }
}

