/*
 * Decompiled with CFR 0.152.
 */
package com.iuap.log.security.mq;

import com.iuap.log.security.exception.RestException;
import com.iuap.log.security.mq.EventConfigUtil;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChannelPoolFactory
extends BasePooledObjectFactory<Channel> {
    protected static Logger logger = LoggerFactory.getLogger(ChannelPoolFactory.class);
    private static Connection connection = null;

    ChannelPoolFactory() {
    }

    private static synchronized void init() throws IOException, RestException, TimeoutException {
        if (connection != null && connection.isOpen()) {
            return;
        }
        ConnectionFactory factory = new ConnectionFactory();
        Address[] addrs = ChannelPoolFactory.getAddress();
        factory.setUsername(EventConfigUtil.getPropertie("mq.username"));
        factory.setPassword(EventConfigUtil.getPropertie("mq.password"));
        connection = factory.newConnection(addrs);
    }

    private static Address[] getAddress() throws RestException {
        String addressStr = EventConfigUtil.getPropertie("mq.address");
        if (addressStr == null) {
            throw new RestException("MQ\u96c6\u7fa4\u5730\u5740\u4e3a\u7a7a");
        }
        String[] addrs = addressStr.split(",");
        ArrayList<Address> addrsList = new ArrayList<Address>();
        for (String addr : addrs) {
            String[] hostAndPost = addr.split(":");
            Address address = new Address(hostAndPost[0], Integer.valueOf(hostAndPost[1]).intValue());
            addrsList.add(address);
        }
        if (addrsList.size() > 0) {
            return addrsList.toArray(new Address[0]);
        }
        return null;
    }

    public Channel create() throws Exception {
        if (connection == null || !connection.isOpen()) {
            ChannelPoolFactory.init();
        }
        Channel channel = connection.createChannel();
        channel.queueDeclare("securityLog", true, false, false, null);
        return channel;
    }

    public PooledObject<Channel> wrap(Channel obj) {
        return new DefaultPooledObject((Object)obj);
    }

    public void destroyObject(PooledObject<Channel> p) throws Exception {
        if (p != null) {
            ((Channel)p.getObject()).close();
        }
    }

    public void activateObject(PooledObject<Channel> p) throws Exception {
        if (!((Channel)p.getObject()).isOpen()) {
            throw new RuntimeException((Throwable)((Channel)p.getObject()).getCloseReason());
        }
    }
}

