/*
 * Decompiled with CFR 0.152.
 */
package com.iuap.log.security.mq;

import com.iuap.log.security.mq.ICustomer;
import com.iuap.log.security.mq.IProducer;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConfigUtil {
    private static volatile IProducer producer = null;
    public static final String MQ_USERNAME = "mq.username";
    public static final String MQ_PASSWORD = "mq.password";
    public static final String MQ_DURABLE = "mq.durable";
    public static final String MQ_CUSTOMER_NUM = "mq.customerNum";
    public static final String MQ_ADDRESS = "mq.address";
    public static final String MQ_MAXTOTAL = "mq.maxtotal";
    public static final String MQ_MAXWAIT = "mq.maxwait";
    public static final String MQ_MAXIDLE = "mq.maxidle";
    public static final String MQ_MINIDLE = "mq.minidle";
    public static final String MQ_SOFTMINEVICTABLEIDLETIMEMILLIS = "mq.softminevictableidletimemillis";
    public static final String TIMEBETWEENEVICTABLEIDLETIMEMILLIS = "mq.timebetweenevictionrunsmillis";
    public static final String MSG_CUSTOMER = "msg.customer";
    public static final String MSG_PRODUCER = "msg.producer";
    public static final String MSG_CLUSTER_CODE = "msg.clusterCode";
    private static EventConfigUtil eventUtil = new EventConfigUtil();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Properties prop;
    private static Map<String, String> defaultMap = new HashMap<String, String>();

    public static String getPropertie(String key) throws SecurityException {
        Properties Properties2 = eventUtil.getConfig();
        String value = Properties2.getProperty(key);
        if (StringUtils.isBlank((String)value)) {
            value = defaultMap.get(key);
            if (!StringUtils.isBlank((String)value)) {
                return value;
            }
            throw new SecurityException(key + "\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        }
        return value;
    }

    public static ICustomer getCustomer() throws SecurityException {
        return (ICustomer)EventConfigUtil.getInstance(EventConfigUtil.getPropertie(MSG_CUSTOMER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IProducer getProducer() throws SecurityException {
        if (producer != null) return producer;
        Class<EventConfigUtil> clazz = EventConfigUtil.class;
        synchronized (EventConfigUtil.class) {
            IProducer producerImpl;
            if (producer != null) return producer;
            producer = producerImpl = (IProducer)EventConfigUtil.getInstance(EventConfigUtil.getPropertie(MSG_PRODUCER));
            // ** MonitorExit[var0] (shouldn't be in output)
            return producer;
        }
    }

    private static Object getInstance(String className) throws SecurityException {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getConfig() {
        if (this.prop == null) {
            EventConfigUtil eventConfigUtil = eventUtil;
            synchronized (eventConfigUtil) {
                if (this.prop == null) {
                    this.prop = new Properties();
                    String filePath = System.getProperty("securitylog-logConfig-filePath");
                    if (filePath == null) {
                        filePath = System.getenv().get("securitylog-logConfig-filePath");
                    }
                    if (filePath == null) {
                        try {
                            this.prop.load(EventConfigUtil.class.getResourceAsStream("/logConfig.properties"));
                        }
                        catch (IOException e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        try {
                            this.prop.load(new FileInputStream(filePath));
                        }
                        catch (IOException e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        return this.prop;
    }

    static {
        defaultMap.put(MQ_CUSTOMER_NUM, "1");
        defaultMap.put(MSG_CUSTOMER, "com.iuap.log.security.mq.CustomerRabbitmqImpl");
        defaultMap.put(MSG_PRODUCER, "com.iuap.log.security.mq.ProducerRabbitmqImpl");
        defaultMap.put(MSG_CLUSTER_CODE, "SERURITYLOG");
    }
}

