/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.ieop.busilog.config.groovyloader;

import com.yonyou.uap.ieop.busilog.exception.BusiLogConfigException;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class GroovyConfigsCache {
    private Logger logger = LoggerFactory.getLogger(GroovyConfigsCache.class);
    private static Class<?> standaloneGroovyObjectClass = null;
    private static Set<Class<?>> groovyObjectClasses = new HashSet();

    public static Class<?> getStandaloneGroovyObjectClass() {
        return standaloneGroovyObjectClass;
    }

    public static Set<Class<?>> getGroovyObjectClasses() {
        return groovyObjectClasses;
    }

    public GroovyConfigsCache() {
        if (this.isStandaloneConfig()) {
            this.initStandaloneGroovyConfig();
        } else {
            this.initGroovyConfigs();
        }
    }

    private void initStandaloneGroovyConfig() {
        if (standaloneGroovyObjectClass != null) {
            return;
        }
        standaloneGroovyObjectClass = this.getGroovyClass(this.getStandaloneConfigFile());
    }

    private void initGroovyConfigs() {
        if (!groovyObjectClasses.isEmpty()) {
            return;
        }
        groovyObjectClasses.clear();
        File configDir = this.getFileByPath("/businessLogConfig");
        if (!configDir.exists() || !configDir.isDirectory()) {
            throw new BusiLogConfigException("Not found any businesslog config, you need a /BusinessLogConfig.groovy or businessLogConfig director");
        }
        for (File each : configDir.listFiles(new GroovyFileNameFilter())) {
            groovyObjectClasses.add(this.getGroovyClass(each));
        }
    }

    void refreshStandaloneGroovyObjectClass() {
        standaloneGroovyObjectClass = null;
        this.initStandaloneGroovyConfig();
    }

    void refreshGroovyObjectClasses() {
        groovyObjectClasses.clear();
        this.initGroovyConfigs();
    }

    private Class<?> getGroovyClass(File configFile) {
        try {
            CompilerConfiguration config = CompilerConfiguration.DEFAULT;
            config.setSourceEncoding("UTF-8");
            GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader(), config);
            return groovyClassLoader.parseClass(configFile);
        }
        catch (IOException e) {
            throw new BusiLogConfigException("There's a failure when read BusinesslogConfig.groovy", e);
        }
    }

    private File getStandaloneConfigFile() {
        File file = this.getFileByPath("/BusinessLogConfig.groovy");
        if (file == null) {
            return null;
        }
        return file;
    }

    public boolean isStandaloneConfig() {
        return this.getStandaloneConfigFile() != null && this.getStandaloneConfigFile().exists();
    }

    private File getFileByPath(String path) {
        try {
            return new ClassPathResource(path).getFile();
        }
        catch (IOException e) {
            this.logger.warn("IOException return null" + e.getMessage());
            return null;
        }
    }

    private class GroovyFileNameFilter
    implements FilenameFilter {
        private GroovyFileNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".groovy");
        }
    }
}

