/*
 * Decompiled with CFR 0.152.
 */
package com.iuap.log.security.mq;

import com.iuap.log.security.entities.SecurityLog;
import com.iuap.log.security.mq.ChannelPool;
import com.iuap.log.security.mq.IProducer;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.MessageProperties;
import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerRabbitmqImpl
implements IProducer {
    protected static Logger logger = LoggerFactory.getLogger(ProducerRabbitmqImpl.class);

    @Override
    public void send(SecurityLog data) throws SecurityException {
        Channel channel = null;
        try {
            channel = this.getChannel();
            channel.basicPublish("", "securityLog", MessageProperties.PERSISTENT_TEXT_PLAIN, SerializationUtils.serialize((Serializable)data));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SecurityException(e.getMessage());
        }
        finally {
            if (channel != null) {
                ChannelPool.release(channel);
            }
        }
    }

    protected Channel getChannel() throws Exception {
        Channel channel = ChannelPool.get();
        return channel;
    }
}

