/*
 * Decompiled with CFR 0.152.
 */
package com.iuap.log.security.utils;

import com.iuap.log.security.exception.ConfigerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigerUtil {
    private static Logger logger = LoggerFactory.getLogger(ConfigerUtil.class);
    private static volatile Map<Object, Object> configerInfo = null;

    public static Map<Object, Object> getConfiger(String fileName) {
        if (configerInfo == null) {
            configerInfo = ConfigerUtil.getAllProperties(fileName);
        }
        return configerInfo;
    }

    private static Map<Object, Object> getAllProperties(String fileName) {
        HashMap<Object, Object> values = new HashMap<Object, Object>();
        InputStream in = null;
        try {
            in = ConfigerUtil.class.getClassLoader().getResourceAsStream(fileName);
            Properties props = new Properties();
            props.load(in);
            Set<Map.Entry<Object, Object>> entrySet = props.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                values.put(entry.getKey(), entry.getValue());
            }
            HashMap<Object, Object> hashMap = values;
            return hashMap;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ConfigerException("\u914d\u7f6e\u6587\u4ef6\u6ca1\u6709\u627e\u5230\uff01" + fileName);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

