/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.ieop.busilog;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yonyou.uap.ieop.busilog.BusiLogThread;
import com.yonyou.uap.ieop.busilog.config.annotation.BusiLogConfig;
import com.yonyou.uap.ieop.busilog.context.ThreadLocalBusiLogContext;
import com.yonyou.uap.ieop.busilog.exception.BusiLogConfigException;
import com.yonyou.uap.ieop.busilog.writer.itf.IBusiLogWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class BusiLogInterceptor {
    private Logger logger = LoggerFactory.getLogger(BusiLogInterceptor.class);
    private static final String BUSINESS_LOG_CONFIG_PROPERTIES_NAME = "busilog-systemConfig.properties";
    private static final String LOG_ENABLE = "yonyou.businesslog.enable";
    private static Boolean isLogEnabled = null;
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private IBusiLogWriter busiLogWriter;

    public void setThreadPoolTaskExecutor(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }

    public void setBusiLogWriter(IBusiLogWriter busiLogWriter) {
        this.busiLogWriter = busiLogWriter;
    }

    public void logAfter(JoinPoint joinPoint, Object result) {
        try {
            this.log(joinPoint, result, null);
        }
        catch (Exception e) {
            this.logger.debug("logAfter-----" + e.getMessage());
        }
    }

    public void afterThrowing(JoinPoint joinPoint, Throwable error) {
        try {
            this.log(joinPoint, null, error);
        }
        catch (Exception e) {
            this.logger.debug("afterThrowing-----" + e.getMessage());
        }
    }

    public void log(JoinPoint joinPoint, Object result, Throwable error) {
        String BLMappingValue = this.getBLMapping(joinPoint);
        if (!this.isLogEnabled() || ThreadLocalBusiLogContext.get().get("_businessMethod") != null) {
            return;
        }
        BusiLogThread busiLogThread = this.getThread(Collections.unmodifiableMap(this.createDefaultContext(joinPoint, result, error)), BLMappingValue, this.getBusiLogWriter());
        if (null == this.getThreadPoolTaskExecutor()) {
            this.logger.error("ThreadPoolTaskExecutor is not set or null");
            new Thread(busiLogThread).start();
        } else {
            int count = 0;
            try {
                this.getThreadPoolTaskExecutor().execute((Runnable)busiLogThread);
                count = 0;
            }
            catch (RejectedExecutionException e) {
                while (count <= 1) {
                    ++count;
                    this.logger.debug("threadpool execute busiLogThread failed" + e.getMessage());
                    try {
                        this.logger.debug("threadpool execute busiLogThread waitting......");
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e1) {
                        this.logger.debug("threadpool execute busiLogThread waitting failed" + e1.getMessage());
                    }
                }
            }
        }
    }

    protected BusiLogThread getThread(Map<String, Object> context, String BLMappingValue, IBusiLogWriter busiLogWriter) {
        return new BusiLogThread(context, BLMappingValue, busiLogWriter);
    }

    private boolean isLogEnabled() {
        if (isLogEnabled != null) {
            return isLogEnabled;
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(new ClassPathResource(BUSINESS_LOG_CONFIG_PROPERTIES_NAME).getFile()));
            isLogEnabled = Boolean.valueOf(properties.getProperty(LOG_ENABLE, "true"));
            return isLogEnabled;
        }
        catch (IOException e) {
            this.logger.error("failure when read " + e.getMessage());
            throw new BusiLogConfigException("failure when read busilog-systemConfig.properties", e);
        }
    }

    private Map<String, Object> createDefaultContext(JoinPoint joinPoint, Object result, Throwable error) {
        Map<String, Object> context = ThreadLocalBusiLogContext.get();
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < args.length; ++i) {
            context.put("_param" + i, args[i]);
        }
        if (null != result) {
            context.put("_methodReturn", result);
        }
        if (null != error) {
            context.put("_executeError", error.getCause());
        }
        context.put("_businessMethod", this.getBLMapping(joinPoint));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        context.put("_time", sdf.format(new Date()));
        if (ThreadLocalBusiLogContext.get().get("_tenantid") != null) {
            context.put("_tenantid", ThreadLocalBusiLogContext.get().get("_tenantid"));
        } else {
            context.put("_tenantid", InvocationInfoProxy.getTenantid());
        }
        if (ThreadLocalBusiLogContext.get().get("_sysid") != null) {
            context.put("_sysid", ThreadLocalBusiLogContext.get().get("_sysid"));
        } else {
            context.put("_sysid", InvocationInfoProxy.getSysid());
        }
        if (ThreadLocalBusiLogContext.get().get("_user") != null) {
            context.put("_user", ThreadLocalBusiLogContext.get().get("_user"));
        } else {
            context.put("_user", InvocationInfoProxy.getUserid());
        }
        if (ThreadLocalBusiLogContext.get().get("_ip") != null) {
            context.put("_ip", ThreadLocalBusiLogContext.get().get("_ip"));
        } else {
            context.put("_ip", InvocationInfoProxy.getExtendAttribute((String)"_ip"));
        }
        return context;
    }

    private String getBLMapping(JoinPoint joinPoint) {
        Method method = this.invocationMethod(joinPoint);
        if (method.isAnnotationPresent(BusiLogConfig.class)) {
            return method.getAnnotation(BusiLogConfig.class).value();
        }
        return joinPoint.getSignature().toString();
    }

    private Method invocationMethod(JoinPoint joinPoint) {
        try {
            Field methodInvocationField = MethodInvocationProceedingJoinPoint.class.getDeclaredField("methodInvocation");
            methodInvocationField.setAccessible(true);
            ProxyMethodInvocation methodInvocation = (ProxyMethodInvocation)methodInvocationField.get(joinPoint);
            return methodInvocation.getMethod();
        }
        catch (NoSuchFieldException e) {
            this.logger.error("invocationMethod NoSuchFieldException return null" + e.getMessage());
            return null;
        }
        catch (IllegalAccessException e) {
            this.logger.error("invocationMethod IllegalAccessException return null" + e.getMessage());
            return null;
        }
    }

    public ThreadPoolTaskExecutor getThreadPoolTaskExecutor() {
        return this.threadPoolTaskExecutor;
    }

    public IBusiLogWriter getBusiLogWriter() {
        return this.busiLogWriter;
    }
}

