/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.ieop.busilog;

import com.yonyou.uap.ieop.busilog.config.groovyloader.GroovyConfigsCache;
import com.yonyou.uap.ieop.busilog.context.ThreadLocalBusiLogContext;
import com.yonyou.uap.ieop.busilog.exception.BusiLogConfigException;
import com.yonyou.uap.ieop.busilog.exception.BusiLogException;
import com.yonyou.uap.ieop.busilog.model.BusinessLog;
import com.yonyou.uap.ieop.busilog.writer.itf.IBusiLogWriter;
import groovy.lang.GroovyObject;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.runtime.GStringImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusiLogThread
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(BusiLogThread.class);
    private static final String LOG_KEY = "log";
    private static final String CATEGORY_KEY = "category";
    private Map<String, Object> context;
    private String BLMappingValue;
    private IBusiLogWriter busiLogWriter;

    public BusiLogThread(Map<String, Object> context, String BLMappingValue, IBusiLogWriter busiLogWriter) {
        this.context = context;
        this.BLMappingValue = BLMappingValue;
        this.busiLogWriter = busiLogWriter;
    }

    @Override
    public void run() {
        ThreadLocalBusiLogContext.putBusinessLogMethod(this.BLMappingValue);
        try {
            GroovyObject groovyConfig = this.getGroovyConfig(this.BLMappingValue);
            if (groovyConfig == null) {
                return;
            }
            groovyConfig.setProperty("context", Collections.unmodifiableMap(this.context));
            BusinessLog logvo = this.createBusinessLog(groovyConfig.invokeMethod(this.BLMappingValue, null));
            this.busiLogWriter.write(logvo);
        }
        catch (IOException e) {
            this.logger.debug("There's a failure when read BusinesslogConfig.groovy" + e.getMessage());
            throw new BusiLogConfigException("There's a failure when read BusinesslogConfig.groovy", e);
        }
        catch (Exception e) {
            this.logger.debug("----------insert data exception-------------" + e.getMessage());
        }
    }

    private BusinessLog createBusinessLog(Object object) {
        BusinessLog businessLog = new BusinessLog();
        businessLog.addContext(this.context);
        if (object instanceof LinkedHashMap) {
            LinkedHashMap map = (LinkedHashMap)object;
            businessLog.setLog(map.get(LOG_KEY).toString());
            businessLog.setCategory(map.get(CATEGORY_KEY).toString());
        } else if (object instanceof GStringImpl || object instanceof String) {
            businessLog.setLog(object.toString());
        } else {
            throw new BusiLogException("failure to execute groovy");
        }
        return businessLog;
    }

    private GroovyObject getGroovyConfig(String businessMethod) throws IOException {
        GroovyConfigsCache groovyConfigsCache = new GroovyConfigsCache();
        if (groovyConfigsCache.isStandaloneConfig()) {
            return this.getGroovyObject(GroovyConfigsCache.getStandaloneGroovyObjectClass());
        }
        for (Class<?> each : GroovyConfigsCache.getGroovyObjectClasses()) {
            try {
                if (each.getMethod(businessMethod, new Class[0]) == null) continue;
                return this.getGroovyObject(each);
            }
            catch (NoSuchMethodException e) {
                this.logger.warn("NoSuchMethodException continue");
            }
        }
        return null;
    }

    private GroovyObject getGroovyObject(Class<?> clazz) {
        try {
            if (null == clazz) {
                throw new BusiLogConfigException("The config must be a groovy class");
            }
            return (GroovyObject)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new BusiLogConfigException("InstantiationException", e);
        }
        catch (IllegalAccessException e) {
            throw new BusiLogConfigException("IllegalAccessException", e);
        }
    }
}

