/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.ieop.busilog.writer;

import com.iuap.log.security.entities.SecurityLog;
import com.iuap.log.security.utils.SpringContextUtil;
import com.yonyou.uap.busilog.entity.Busilog;
import com.yonyou.uap.ieop.busilog.model.BusinessLog;
import com.yonyou.uap.ieop.busilog.writer.itf.IBusiLogWriter;
import com.yyjz.icop.mq.common.MqMessage;
import com.yyjz.icop.mq.sender.MsgSender;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BusiLogRestWriter
implements IBusiLogWriter {
    private static Logger logger = LoggerFactory.getLogger(BusiLogRestWriter.class);
    private static final AtomicLong createCount = new AtomicLong(0L);

    @Override
    public void write(BusinessLog businessLog) {
        System.out.println(businessLog);
        Busilog log = this.createBusiLogVO(businessLog);
        SecurityLog securityLog = new SecurityLog();
        BeanUtils.copyProperties((Object)log, (Object)securityLog);
        long newCreateCount = createCount.incrementAndGet();
        int i = (int)(newCreateCount % 7L);
        MsgSender msgSender = (MsgSender)SpringContextUtil.getBean("msgSender");
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody((Object)log);
        msgSender.sendMessage(mqMessage, "securitylog_queue" + i);
    }

    private Busilog createBusiLogVO(BusinessLog businessLog) {
        Busilog logvo = new Busilog();
        Map<String, Object> context = businessLog.getContext();
        if (context.get("_userid") != null) {
            logvo.setUserId((String)context.get("_userid"));
        }
        if (context.get("_usercode") != null) {
            logvo.setUserCode((String)context.get("_usercode"));
        }
        if (context.get("_time") != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date date = sdf.parse((String)context.get("_time"));
                logvo.setTimestamp(date);
            }
            catch (ParseException e) {
                logger.error("\u65e5\u671f\u8f6c\u6362\u51fa\u9519", (Throwable)e);
            }
        }
        if (context.get("_ip") != null) {
            logvo.setIp((String)context.get("_ip"));
        }
        if (context.get("_tenantid") != null) {
            logvo.setLessee((String)context.get("_tenantid"));
        }
        if (context.get("_sysid") != null) {
            logvo.setSystem((String)context.get("_sysid"));
        }
        logvo.setContentDes(businessLog.getLog());
        logvo.setCategory(businessLog.getCategory());
        return logvo;
    }
}

