/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.yht.cache;

import com.yonyou.yht.cache.utils.SerializUtil;
import com.yonyou.yht.sdkutils.StringUtils;
import com.yonyou.yht.security.esapi.EncryptException;
import com.yonyou.yht.security.utils.TokenGenerator;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springside.modules.nosql.redis.JedisTemplate;
import org.springside.modules.nosql.redis.JedisUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;

public class CacheManager
implements ApplicationContextAware {
    public static final String TOKEN_SEED = "token_seed";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final Logger logger = LoggerFactory.getLogger(CacheManager.class);
    private int sessionTimeout = 3600;
    private int reConnectionTime = 1000;
    private boolean canSetClientName = true;
    private JedisTemplate jedisTemplate;
    private static ApplicationContext s_appContext;

    public JedisTemplate getJedisTemplate() {
        return this.jedisTemplate;
    }

    public void setJedisTemplate(JedisTemplate jedisTemplate) {
        this.jedisTemplate = jedisTemplate;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Map<String, Object> getAllSessionAttrCache(String sid) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map<byte[], byte[]> redisMap = this.hgetAll(sid);
        for (byte[] byteKey : redisMap.keySet()) {
            String key = new String(byteKey, Charset.forName(DEFAULT_CHARSET));
            Object obj = SerializUtil.byteToObject(redisMap.get(byteKey));
            hashMap.put(key, obj);
        }
        this.expire(sid, this.sessionTimeout);
        return hashMap;
    }

    public void removeSessionCache(String sid) {
        this.jedisTemplate.del(new String[]{sid});
    }

    public <T extends Serializable> void putSessionCacheAttribute(String sid, String key, T value) {
        this.putSessionCacheAttribute(sid, key, value, this.sessionTimeout);
    }

    public <T extends Serializable> void putSessionCacheAttribute(String sid, String key, T value, int timeout) {
        this.hset(sid, key, value);
        if (timeout > 0) {
            this.expire(sid, timeout);
        }
    }

    public <T extends Serializable> void updateSessionCacheAttribute(String sid, String key, T value) {
        if (this.jedisTemplate.hexists(sid, key).booleanValue()) {
            this.putSessionCacheAttribute(sid, key, value);
        }
    }

    public <T extends Serializable> T getSessionCacheAttribute(String sid, String key) {
        T result = null;
        boolean isExist = this.exists(sid);
        if (isExist) {
            this.expire(sid, this.sessionTimeout);
            result = this.hget(sid, key);
        }
        return result;
    }

    public void removeSessionCacheAttribute(String sid, String key) {
        if (StringUtils.isNotBlank((String)sid) && StringUtils.isNotBlank((String)key)) {
            this.jedisTemplate.hdel(sid, new String[]{key});
        }
    }

    public <T extends Serializable> T getUserCache(String key) {
        boolean isExist = this.exists(key);
        T result = null;
        if (isExist) {
            this.expire(key, this.sessionTimeout);
            result = this.get(key);
        }
        return result;
    }

    public <T extends Serializable> T getCurUser(String prefix, String uname) {
        return StringUtils.isNotBlank((String)uname) ? (T)this.getUserCache(this.createUserCacheKey(prefix, uname)) : null;
    }

    public <T extends Serializable> T getCurUser(String uname) {
        return StringUtils.isNotBlank((String)uname) ? (T)this.getUserCache(this.createUserCacheKey(uname)) : null;
    }

    public <T extends Serializable> void cacheUser(String prefix, String uname, T user) {
        this.putUserCache(this.createUserCacheKey(prefix, uname), user);
    }

    public <T extends Serializable> void cacheUser(String uname, T user) {
        this.putUserCache(this.createUserCacheKey(uname), user);
    }

    public <T extends Serializable> void putUserCache(String key, T value) {
        this.putTimedCache(key, value, this.sessionTimeout);
    }

    private String createUserCacheKey(String prefix, String uname) {
        return new StringBuffer("user.info.login" + prefix).append(":").append(uname).toString();
    }

    private String createUserCacheKey(String uname) {
        return new StringBuffer("user.info.login.tenant").append(":").append(uname).toString();
    }

    public <T extends Serializable> void disCacheUser(String uname) {
        this.removeCache(this.createUserCacheKey(uname));
    }

    public <T extends Serializable> void disCacheUser(String prefix, String uname) {
        this.removeCache(this.createUserCacheKey(prefix, uname));
    }

    public String findSeed() throws EncryptException {
        String seed = this.getSeedValue(TOKEN_SEED);
        if (StringUtils.isBlank((String)seed)) {
            seed = TokenGenerator.genSeed();
            this.jedisTemplate.set(TOKEN_SEED, seed);
        }
        return seed;
    }

    public String getSeedValue(String key) {
        return this.jedisTemplate.get(key);
    }

    public <T extends Serializable> void putTimedCache(String key, T value, int timeout) {
        this.setex(key, value, timeout);
    }

    public <T extends Serializable> void set(final String key, final T value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                byte[] valueBytes = SerializUtil.objectToByte(value);
                jedis.set(keyBytes, valueBytes);
            }
        });
    }

    public <T extends Serializable> void setex(final String key, final T value, final int timeout) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] valueBytes = SerializUtil.objectToByte(value);
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                jedis.setex(keyBytes, timeout, valueBytes);
            }
        });
    }

    public void expire(final String key, final int timeout) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.expire(key, timeout);
            }
        });
    }

    public Boolean exists(final String key) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.exists(key);
            }
        });
    }

    public <T extends Serializable> T get(final String key) {
        return (T)((Serializable)this.execute(new JedisAction<T>(){

            @Override
            public T action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                if (keyBytes == null) {
                    return null;
                }
                byte[] valueBytes = jedis.get(keyBytes);
                if (valueBytes == null) {
                    return null;
                }
                return (Serializable)SerializUtil.byteToObject(valueBytes);
            }
        }));
    }

    public <T extends Serializable> T hget(final String key, final String fieldName) {
        return (T)((Serializable)this.execute(new JedisAction<T>(){

            @Override
            public T action(Jedis jedis) {
                byte[] fieldBytes;
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                byte[] attrBytes = jedis.hget(keyBytes, fieldBytes = fieldName.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET)));
                if (attrBytes == null) {
                    return null;
                }
                return (Serializable)SerializUtil.byteToObject(attrBytes);
            }
        }));
    }

    public Map<byte[], byte[]> hgetAll(final String key) {
        return this.execute(new JedisAction<Map<byte[], byte[]>>(){

            @Override
            public Map<byte[], byte[]> action(Jedis jedis) {
                return jedis.hgetAll(key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET)));
            }
        });
    }

    public <T extends Serializable> void hset(final String key, final String fieldName, final T value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                byte[] fieldBytes = fieldName.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                byte[] valueBytes = SerializUtil.objectToByte(value);
                jedis.hset(keyBytes, fieldBytes, valueBytes);
            }
        });
    }

    public void removeCache(String key) {
        if (key != null && key.length() > 0) {
            this.jedisTemplate.del(new String[]{key});
        }
    }

    public <T> T execute(JedisAction<T> jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = this.getJedis();
            if (this.canSetClientName) {
                try {
                    jedis.clientSetname("yht".getBytes(Charset.forName(DEFAULT_CHARSET)));
                }
                catch (Throwable e) {
                    logger.error("redis can not set client name");
                    this.canSetClientName = false;
                }
            }
            T e = jedisAction.action(jedis);
            return e;
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public void execute(JedisActionNoResult jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = this.getJedis();
            if (this.canSetClientName) {
                try {
                    jedis.clientSetname("yht".getBytes(Charset.forName(DEFAULT_CHARSET)));
                }
                catch (Throwable e) {
                    logger.error("redis can not set client name");
                    this.canSetClientName = false;
                }
            }
            jedisAction.action(jedis);
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    private Jedis getJedis() {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.jedisTemplate.getJedisPool().getResource();
        }
        catch (JedisConnectionException jedisException) {
            try {
                logger.warn("Redis connection " + this.jedisTemplate.getJedisPool().getAddress() + " lost once ,and will try again after " + this.getReConnectionTime() + " millsecond.", (Throwable)jedisException);
                Thread.sleep(this.reConnectionTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.warn("Redis connection " + this.jedisTemplate.getJedisPool().getAddress() + " will try again.");
            jedis = (Jedis)this.jedisTemplate.getJedisPool().getResource();
        }
        return jedis;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleJedisException(JedisException jedisException) {
        if (jedisException instanceof JedisConnectionException) {
            logger.error("Redis connection " + this.jedisTemplate.getJedisPool().getAddress() + " lost.", (Throwable)jedisException);
            return true;
        } else if (jedisException instanceof JedisDataException) {
            if (jedisException.getMessage() == null || jedisException.getMessage().indexOf("READONLY") == -1) return false;
            logger.error("Redis connection " + this.jedisTemplate.getJedisPool().getAddress() + " are read-only slave.", (Throwable)jedisException);
            return true;
        } else {
            logger.error("Jedis exception happen.", (Throwable)jedisException);
        }
        return true;
    }

    protected void closeResource(Jedis jedis, boolean conectionBroken) {
        try {
            if (conectionBroken) {
                this.jedisTemplate.getJedisPool().returnBrokenResource(jedis);
            } else {
                this.jedisTemplate.getJedisPool().returnResource(jedis);
            }
        }
        catch (Exception e) {
            logger.error("return back jedis failed, will fore close the jedis.", (Throwable)e);
            JedisUtils.destroyJedis((Jedis)jedis);
        }
    }

    public long getTTL(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.ttl(key);
            }
        });
    }

    public void rpush(final String key, final String ... values) {
        this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.rpush(key, values);
            }
        });
    }

    public List<String> lrange(final String key, final Long start, final Long end) {
        return this.execute(new JedisAction<List<String>>(){

            @Override
            public List<String> action(Jedis jedis) {
                return jedis.lrange(key, start.longValue(), end.longValue());
            }
        });
    }

    public Long llen(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.llen(key);
            }
        });
    }

    public Long lrem(final String key, final Long count, final String value) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.lrem(key, count.longValue(), value);
            }
        });
    }

    public <T extends Serializable> T getTicketCacheAttribute(String sid, String key) {
        T result = null;
        boolean isExist = this.exists(sid);
        if (isExist) {
            this.expire(sid, this.sessionTimeout);
            result = this.hgetByKryo(sid, key);
        }
        return result;
    }

    private <T extends Serializable> T hgetByKryo(final String key, final String fieldName) {
        return (T)((Serializable)this.execute(new JedisAction<T>(){

            @Override
            public T action(Jedis jedis) {
                byte[] fieldBytes;
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                byte[] attrBytes = jedis.hget(keyBytes, fieldBytes = fieldName.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET)));
                if (attrBytes == null) {
                    return null;
                }
                return (Serializable)SerializUtil.byteToObjectByKryo(attrBytes);
            }
        }));
    }

    private <T extends Serializable> void hsetByKryo(final String key, final String fieldName, final T value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] keyBytes = key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                byte[] fieldBytes = fieldName.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET));
                byte[] valueBytes = SerializUtil.objectToByteByKryo(value);
                jedis.hset(keyBytes, fieldBytes, valueBytes);
            }
        });
    }

    public <T extends Serializable> void putTicketCacheAttribute(String sid, String key, T value) {
        this.putTicketCacheAttribute(sid, key, value, this.sessionTimeout);
    }

    public <T extends Serializable> void putTicketCacheAttribute(String sid, String key, T value, int timeout) {
        this.hsetByKryo(sid, key, value);
        if (timeout > 0) {
            this.expire(sid, timeout);
        }
    }

    public boolean removeCacheAttribute(String sid, String key) {
        long count;
        return StringUtils.isNotBlank((String)sid) && StringUtils.isNotBlank((String)key) && (count = this.jedisTemplate.hdel(sid, new String[]{key}).longValue()) > 0L;
    }

    public Map<String, Object> getAllTicketAttrCache(String sid) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map<byte[], byte[]> redisMap = this.hgetAll(sid);
        for (byte[] byteKey : redisMap.keySet()) {
            String key = new String(byteKey, Charset.forName(DEFAULT_CHARSET));
            Object obj = SerializUtil.byteToObjectByKryo(redisMap.get(byteKey));
            hashMap.put(key, obj);
        }
        this.expire(sid, this.sessionTimeout);
        return hashMap;
    }

    public Set<byte[]> hkeys(final String key) {
        return this.execute(new JedisAction<Set<byte[]>>(){

            @Override
            public Set<byte[]> action(Jedis jedis) {
                return jedis.hkeys(key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET)));
            }
        });
    }

    public Set<String> getAllTicketIds(String sid) {
        Set<byte[]> tids = this.hkeys(sid);
        HashSet<String> tidSet = new HashSet<String>();
        for (byte[] byteKey : tids) {
            String key = new String(byteKey, Charset.forName(DEFAULT_CHARSET));
            tidSet.add(key);
        }
        this.expire(sid, this.sessionTimeout);
        return tidSet;
    }

    public int getReConnectionTime() {
        return this.reConnectionTime;
    }

    public void setReConnectionTime(int reConnectionTime) {
        this.reConnectionTime = reConnectionTime;
    }

    public ScanResult<Map.Entry<String, String>> hscan(final String key, final String cursor, final int count) {
        return this.execute(new JedisAction<ScanResult<Map.Entry<String, String>>>(){

            @Override
            public ScanResult<Map.Entry<String, String>> action(Jedis jedis) {
                ScanParams params = new ScanParams();
                params.count(count);
                return jedis.hscan(key, cursor, params);
            }
        });
    }

    public Set<String> keys(final String key) {
        Set<byte[]> byteKeys = this.execute(new JedisAction<Set<byte[]>>(){

            @Override
            public Set<byte[]> action(Jedis jedis) {
                return jedis.keys(key.getBytes(Charset.forName(CacheManager.DEFAULT_CHARSET)));
            }
        });
        HashSet<String> keys = new HashSet<String>();
        if (byteKeys != null && !byteKeys.isEmpty()) {
            for (byte[] byteKey : byteKeys) {
                keys.add(new String(byteKey, Charset.forName(DEFAULT_CHARSET)));
            }
        }
        return keys;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        logger.info("yht cache  setApplicationContext{}", (Object)applicationContext);
        s_appContext = applicationContext;
    }

    public static CacheManager getCacheBean() {
        if (s_appContext != null) {
            CacheManager cacheMg = (CacheManager)s_appContext.getBean(CacheManager.class);
            logger.info("yht cache getCacheBean {}", (Object)cacheMg);
            return cacheMg;
        }
        return null;
    }

    public static interface JedisActionNoResult {
        public void action(Jedis var1);
    }

    public static interface JedisAction<T> {
        public T action(Jedis var1);
    }
}

