/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.yht.cache;

import com.yonyou.yht.cache.CacheManager;
import com.yonyou.yht.sdk.AbstractSessionStore;
import com.yonyou.yht.sdk.CasClientRuntimeException;
import com.yonyou.yht.security.esapi.EncryptException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisSessionStore
extends AbstractSessionStore {
    private CacheManager cache = CacheManager.getCacheBean();
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public String findSeed() {
        try {
            return this.cache.findSeed();
        }
        catch (EncryptException e) {
            this.logger.error("generate seed error:", (Throwable)e);
            throw new CasClientRuntimeException("generate seed error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Serializable> void putSessionCacheAttribute(String sid, String key, T value) {
        try {
            this.logger.trace("start to put {}", (Object)key);
            this.cache.putSessionCacheAttribute(sid, key, value);
        }
        catch (Exception e) {
            this.logger.error("putSessionCacheAttribute:", (Throwable)e);
        }
        finally {
            this.logger.trace("end to put {}", (Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionCacheAttribute(String sid, String key) {
        try {
            this.logger.trace("start to remove {}", (Object)key);
            this.cache.removeSessionCacheAttribute(sid, key);
        }
        catch (Exception e) {
            this.logger.error("removeSessionCacheAttribute:", (Throwable)e);
        }
        finally {
            this.logger.trace("end to remove {}", (Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Serializable> T getSessionCacheAttribute(String sid, String key) {
        try {
            this.logger.trace("start to get {}", (Object)key);
            Object t = this.cache.getSessionCacheAttribute(sid, key);
            return t;
        }
        catch (Exception e) {
            this.logger.error("getSessionCacheAttribute:", (Throwable)e);
        }
        finally {
            this.logger.trace("end to get {}", (Object)key);
        }
        return null;
    }
}

