/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.yht.cache.redis;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.nosql.redis.pool.ConnectionInfo;
import org.springside.modules.nosql.redis.pool.JedisDirectPool;
import org.springside.modules.nosql.redis.pool.JedisPool;
import org.springside.modules.nosql.redis.pool.JedisSentinelPool;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisPoolConfig;

public class RedisPoolFactory {
    public static final String DIRECT_POOL_PREFIX = "direct:";
    public static final String SENTINEL_POOL_PREFIX = "direct:";
    private static Logger logger = LoggerFactory.getLogger(RedisPoolFactory.class);
    private String poolName;
    private String[] sentinelHostAndPorts;
    private String[] hostAndPorts;
    private String[] masterNames;
    private int poolSize = -1;
    private int database = 0;
    private String password = ConnectionInfo.DEFAULT_PASSWORD;
    private int timeout = 2000;
    private int waitTimeout = 10000;

    public RedisPoolFactory setUrl(String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException ex) {
            logger.error("Incorrect URI for initializing Jedis pool", (Throwable)ex);
            return this;
        }
        Properties prop = new Properties();
        String query = uri.getQuery();
        if (query != null) {
            try {
                prop.load(new StringReader(query.replace("&", "\n")));
            }
            catch (IOException ex) {
                logger.error("Failed to load the URI query string as stream", (Throwable)ex);
                return this;
            }
        } else {
            logger.error("No redis pool information set in query part of URI");
            return this;
        }
        String authority = uri.getAuthority();
        if ("direct".equals(uri.getScheme())) {
            this.setShardedDirectHosts(authority);
        } else {
            this.setSentinelHosts(authority);
        }
        if (prop.getProperty("masterName") != null) {
            String masterName = prop.getProperty("masterName");
            this.setShardedMasterNames(masterName);
        }
        if (prop.getProperty("poolName") != null) {
            this.setPoolName(prop.getProperty("poolName"));
        }
        if (prop.getProperty("poolSize") != null) {
            this.setPoolSize(Integer.parseInt(prop.getProperty("poolSize")));
        }
        if (prop.getProperty("database") != null) {
            this.setDatabase(Integer.parseInt(prop.getProperty("database")));
        }
        if (prop.getProperty("password") != null) {
            this.setPassword(prop.getProperty("password"));
        }
        if (prop.getProperty("timeout") != null) {
            this.setTimeout(Integer.parseInt(prop.getProperty("timeout")));
        }
        if (prop.getProperty("waitTimeout") != null) {
            this.setWaitTimeout(Integer.parseInt(prop.getProperty("waitTimeout")));
        }
        return this;
    }

    public void setWaitTimeout(int waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    public RedisPoolFactory setPoolName(String poolName) {
        this.poolName = poolName;
        return this;
    }

    public RedisPoolFactory setSentinelHosts(String[] sentinelHostsAndPorts) {
        this.sentinelHostAndPorts = sentinelHostsAndPorts;
        return this;
    }

    public RedisPoolFactory setSentinelHosts(String sentinelHostsAndPorts) {
        if (sentinelHostsAndPorts != null) {
            this.sentinelHostAndPorts = sentinelHostsAndPorts.split(",");
        }
        return this;
    }

    public RedisPoolFactory setMasterName(String masterName) {
        this.masterNames = new String[]{masterName};
        return this;
    }

    public RedisPoolFactory setShardedMasterNames(String[] shardedMasterNames) {
        this.masterNames = shardedMasterNames;
        return this;
    }

    public RedisPoolFactory setShardedMasterNames(String shardedMasterNames) {
        if (shardedMasterNames != null) {
            this.masterNames = shardedMasterNames.split(",");
        }
        return this;
    }

    public RedisPoolFactory setDirectHost(String hostAndPort) {
        this.hostAndPorts = new String[]{hostAndPort};
        return this;
    }

    public RedisPoolFactory setShardedDirectHosts(String[] shardedHostAndPorts) {
        this.hostAndPorts = shardedHostAndPorts;
        return this;
    }

    public RedisPoolFactory setShardedDirectHosts(String shardedHostAndPorts) {
        if (shardedHostAndPorts != null) {
            this.hostAndPorts = shardedHostAndPorts.split(",");
        }
        return this;
    }

    public RedisPoolFactory setPoolSize(int poolSize) {
        this.poolSize = poolSize;
        return this;
    }

    public RedisPoolFactory setDatabase(int database) {
        this.database = database;
        return this;
    }

    public RedisPoolFactory setPassword(String password) {
        this.password = password;
        return this;
    }

    public RedisPoolFactory setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public JedisPool buildPool() {
        if (this.poolName == null || this.poolName.length() == 0) {
            throw new IllegalArgumentException("poolName is null or empty");
        }
        if (this.poolSize < 1) {
            throw new IllegalArgumentException("poolSize is less then one");
        }
        JedisPoolConfig config = JedisPool.createPoolConfig((int)this.poolSize);
        config.setMaxWaitMillis((long)this.waitTimeout);
        ConnectionInfo connectionInfo = new ConnectionInfo(this.database, this.password, this.timeout);
        if (this.isDirect()) {
            return this.buildDirectPool(this.hostAndPorts[0], connectionInfo, config);
        }
        if (this.sentinelHostAndPorts == null || this.sentinelHostAndPorts.length == 0) {
            throw new IllegalArgumentException("sentinelHostsAndPorts is null or empty");
        }
        if (this.masterNames == null || this.masterNames.length == 0) {
            throw new IllegalArgumentException("masterNames is null or empty");
        }
        return this.buildSentinelPool(this.masterNames[0], connectionInfo, config);
    }

    public List<JedisPool> buildShardedPools() {
        if (this.poolName == null || this.poolName.length() == 0) {
            throw new IllegalArgumentException("poolName is null or empty");
        }
        if (this.poolSize < 1) {
            throw new IllegalArgumentException("poolSize is less then one");
        }
        JedisPoolConfig config = JedisPool.createPoolConfig((int)this.poolSize);
        config.setMaxWaitMillis((long)this.waitTimeout);
        ConnectionInfo connectionInfo = new ConnectionInfo(this.database, this.password, this.timeout);
        ArrayList<JedisPool> jedisPools = new ArrayList<JedisPool>();
        if (this.isDirect()) {
            for (String hostAndPort : this.hostAndPorts) {
                jedisPools.add(this.buildDirectPool(hostAndPort, connectionInfo, config));
            }
        } else {
            if (this.sentinelHostAndPorts == null || this.sentinelHostAndPorts.length == 0) {
                throw new IllegalArgumentException("sentinelHostsAndPorts is null or empty");
            }
            if (this.masterNames == null || this.masterNames.length == 0) {
                throw new IllegalArgumentException("masterNames is null or empty");
            }
            for (String masterName : this.masterNames) {
                jedisPools.add(this.buildSentinelPool(masterName, connectionInfo, config));
            }
        }
        return jedisPools;
    }

    private JedisPool buildDirectPool(String hostAndPort, ConnectionInfo connectionInfo, JedisPoolConfig config) {
        logger.info("Building JedisDirectPool, on redis server {}", (Object)hostAndPort);
        String[] hostPort = hostAndPort.split(":");
        HostAndPort masterAddress = new HostAndPort(hostPort[0], Integer.parseInt(hostPort[1]));
        return new JedisDirectPool(this.poolName, masterAddress, connectionInfo, config);
    }

    private JedisPool buildSentinelPool(String masterName, ConnectionInfo connectionInfo, JedisPoolConfig config) {
        logger.info("Building JedisSentinelPool, on sentinel sentinelHosts:" + Arrays.toString(this.sentinelHostAndPorts) + ", masterName is " + masterName);
        HostAndPort[] sentinelAddresses = new HostAndPort[this.sentinelHostAndPorts.length];
        for (int i = 0; i < this.sentinelHostAndPorts.length; ++i) {
            String[] hostPort = this.sentinelHostAndPorts[i].split(":");
            sentinelAddresses[i] = new HostAndPort(hostPort[0], Integer.parseInt(hostPort[1]));
        }
        return new JedisSentinelPool(this.poolName, sentinelAddresses, masterName, connectionInfo, config);
    }

    private boolean isDirect() {
        return this.hostAndPorts != null && this.hostAndPorts.length > 0;
    }

    public static JedisPool createJedisPool(String url) {
        return new RedisPoolFactory().setUrl(url).buildPool();
    }

    public static List<JedisPool> createShardedJedisPools(String shardedUrl) {
        return new RedisPoolFactory().setUrl(shardedUrl).buildShardedPools();
    }
}

