package com.yyjz.icop.base.exception;

import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 全局异常处理
 * @author Administrator
 *
 */
public class ControllerExceptionHandler implements HandlerExceptionResolver {

	private static final Logger LOGGER = LoggerFactory
			.getLogger(ControllerExceptionHandler.class);

	@Override
	public ModelAndView resolveException(HttpServletRequest request,
			HttpServletResponse response, Object handler, Exception ex) {
		LOGGER.error(ex.getMessage());
		String requestType = request.getHeader("X-Requested-With");
		if (!StringUtils.isEmpty(requestType)
				&& "XMLHttpRequest".equals(requestType)) {
			// Ajax请求异常返回
			response.setCharacterEncoding("utf-8");
			JSONObject json = new JSONObject();
			json.put("success", false);
			json.put("msg", ex.getMessage());
			try {
				response.getWriter().write(json.toJSONString());
			} catch (IOException e) {
				e.printStackTrace();
			}
			return null;
		} else {
			// 普通请求异常返回
			// TODO 按照不同异常类型返回不同异常界面
			return new ModelAndView("500");
		}
	}
}
