/**
 * $文件说明$
 *
 * @author Alex
 * @version 
 * @see
 * @since
 * @time 2016年4月29日 下午4:50:07
 */
package com.yyjz.icop.base.vo.tree;

import com.yyjz.icop.base.vo.SuperVO;

import javax.persistence.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 本类主要功能：树结构的vo超类
 * <p>
 * @version YYCC_V1.0
 * @author yujian1
 * @time 2016年4月29日 下午4:50:07
 */
public class SuperTreeVO extends SuperVO{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	//内码
	protected String innercode;
	public String getInnercode() {
		return innercode;
	}

	public void setInnercode(String innercode) {
		this.innercode = innercode;
	}
    // 是否可选中
	protected boolean selectable = true;

	public boolean getSelectable() {
		return this.selectable;
	}

	public void setSelectable(boolean selectable) {
		this.selectable = selectable;
	}

	/**
	 * 孩子节点列表
	 */
	@Transient
	private List<SuperTreeVO> children = new ArrayList<SuperTreeVO>();
	
	// 添加孩子节点
	public void addChild(SuperTreeVO vo) {
		children.add(vo);
	}
	
	public List<SuperTreeVO> getChildren() {
		return children;
	}

	public void setChildren(List<SuperTreeVO> children) {
		this.children = children;
	}

	public void sortChildren() {
		if (children.size() != 0) {
			// 对本层节点进行排序（可根据不同的排序属性，传入不同的比较器，这里 传入innercode比较器）
			Collections.sort(children, new ComparatorTree());
			// 对每个节点的下一层节点进行排序			
			for (int i = 0; i < children.size(); i++) {
				((SuperTreeVO) children.get(i)).sortChildren();
			}
		}
	}

}
