package com.yyjz.icop.file.fastdfs;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.file.IFileTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FastdfsTool implements IFileTool {
	public static Logger logger = LoggerFactory.getLogger(FastdfsTool.class);
	/**
	 * 文件下载
	 * </p>request.getParameter("id")
	 * @param request
	 * @param response
	 */
	public void down(HttpServletRequest request, HttpServletResponse response) {
		String fdfsid = request.getParameter("id");
		response.setContentType("image/jpg;charset=utf-8");
		java.io.BufferedInputStream bis = null;
		java.io.BufferedOutputStream bos = null;
		try {
			byte[] contents = FastdfsClient.getInstance(request).download(fdfsid);
			if(contents==null){
				logger.error("没有找到图片内容！");				
				return;
			}
			bis = new BufferedInputStream(new ByteArrayInputStream(contents));
			bos = new BufferedOutputStream(response.getOutputStream());
			byte[] buff = new byte[2048];
			int bytesRead;
			while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
				bos.write(buff, 0, bytesRead);
			}
		} catch (Exception e) {
			logger.error("no pic load",e);
		} finally {
			if (bis != null)
				try {
					bis.close();
				} catch (IOException e) {
					logger.error("bis close exception",e);
				}
			if (bos != null)
				try {
					bos.close();
				} catch (IOException e) {
					logger.error("bos close exception",e);
				}
		}
	}
	/**
	 * 文件上传
	 * </p>支持多文件上传
	 * </p>返回一个json对象，key=fileIds，可通过 jsonObj.get("fileIds")获得，
	 * 一般不需要自己获取，前段直接获取
	 * 默认上传文件大小为3M
	 * @param request
	 * @return
	 */
	public JSONObject upload(HttpServletRequest request) {
		return upload(request, IFileTool.defaultSize);
	}
	/**
	 * 文件上传
	 * </p>支持多文件上传
	 * </p>返回一个json对象，key=fileIds，可通过 jsonObj.get("fileIds")获得，
	 * 一般不需要自己获取，前段直接获取
	 * limitSize限制大小，单位为字节，如2.17 MB (2,286,075 字节)
	 * @param request
	 * @param limitSize限制大小，单位为字节，如2.17 MB (2,286,075 字节)
	 * @return
	 */
	public JSONObject upload(HttpServletRequest request, long limitSize) {
		List<String> fileName = new ArrayList<String>();
		JSONObject jsonObj = new JSONObject();
		CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
		if (multipartResolver.isMultipart(request)) {
			MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
			Iterator<String> iter = multiRequest.getFileNames();
			while (iter.hasNext()) {
				// 一次遍历所有文件
				MultipartFile file = multiRequest.getFile(iter.next().toString());
				if (file.getSize() > limitSize) { 
					jsonObj.put("fileIds", "-1");
					jsonObj.put("fileErr", "上传图片大小不能超过"+limitSize+"M");
					return jsonObj;
				}
				if (file != null) {
					// 上传
					try {
						FastdfsClient client = FastdfsClient.getInstance(request);
						fileName.add(client.upload(file.getBytes()));
					} catch (IllegalStateException e) {
						logger.error("上传文件错误", e);
						throw new RuntimeException(e);
					} catch (IOException e) {
						logger.error("上传文件错误", e);
						throw new RuntimeException(e);
					} catch (Exception e) {
						logger.error("上传文件到fdfs错误", e);
						throw new RuntimeException(e);
					}
				}
			}
		}
		jsonObj.put("fileIds", fileName);
		return jsonObj;
	}
}
