package com.yyjz.icop.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 参照树返回结构数据
 *
 * @author 张远志
 * @time 2016年8月10日11:27:45
 */
public class ReferTreeData {
    /**
     * 节点ID
     */
    private String id;
    /**
     * 节点编号
     */
    private String code;
    /**
     * 节点名称
     */
    private String name;
    /**
     * 是否叶子节点
     */
    private Boolean isLeaf;
    /**
     * 下级节点列表
     */
    private List<ReferTreeData> children;
    /**
     * 附加数据
     */
    private Object extdata;

    private boolean selectable = true;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getIsLeaf() {
        return isLeaf;
    }

    public void setIsLeaf(Boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public List<ReferTreeData> getChildren() {
        return children;
    }

    public void setChildren(List<ReferTreeData> children) {
        this.children = children;
    }

    public Object getExtdata() {
        return extdata;
    }

    public void setExtdata(Object extdata) {
        this.extdata = extdata;
    }

    public boolean getSelectable() {
        return selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean addChild(ReferTreeData child) {
        if (null == this.children) {
            this.children = new ArrayList<>();
        }
        return this.children.add(child);
    }

    public boolean addChildren(List<ReferTreeData> children) {
        if (null == this.children) {
            this.children = children;
            return true;
        } else {
            return this.children.addAll(children);
        }
    }
    
    public static boolean judgeInnerCode(String innerCode) {
        if (org.apache.commons.lang.StringUtils.isBlank(innerCode)) {
            return false;
        }
        if ((innerCode.length() % 4) != 0) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]+");
        Matcher matcher = pattern.matcher(innerCode);
        if (!matcher.matches()) {
            return false;
        }
        return true;
    }
}
