package com.yyjz.icop.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtil {
	
	private RestTemplate restTemplate = new RestTemplate();
	
	public void setRestTemplate(RestTemplate restTemplate) {
		this.restTemplate = restTemplate;
	}
	
	public String _post(ServletRequest req, String url, Map<String, ?> params) {
		HttpServletRequest request = (HttpServletRequest) req;
		//拿到header信息
		HttpHeaders requestHeaders = new HttpHeaders();
		requestHeaders.setContentType(MediaType.APPLICATION_JSON);
	    Enumeration<String> headerNames = request.getHeaderNames();
	    while (headerNames.hasMoreElements()) {
	      String key = (String) headerNames.nextElement();
	      String value = request.getHeader(key);
	      requestHeaders.add(key, value);
	    }
	    net.sf.json.JSONObject jsonParams = net.sf.json.JSONObject.fromObject(params);
	    HttpEntity<net.sf.json.JSONObject> requestEntity = new HttpEntity<net.sf.json.JSONObject>(jsonParams, requestHeaders);
	    String result = restTemplate.postForObject(url, requestEntity, String.class);
		return result;
	}
	
	public String post(ServletRequest req, String url, Object params, MediaType mediaType) {
		HttpServletRequest request = (HttpServletRequest) req;
		//拿到header信息
		HttpHeaders requestHeaders = new HttpHeaders();
		requestHeaders.setContentType(mediaType);
	    Enumeration<String> headerNames = request.getHeaderNames();
	    while (headerNames.hasMoreElements()) {
	      String key = (String) headerNames.nextElement();
	      String value = request.getHeader(key);
	      requestHeaders.add(key, value);
	    }
	    net.sf.json.JSONObject jsonParams = net.sf.json.JSONObject.fromObject(params);
	    HttpEntity<net.sf.json.JSONObject> requestEntity = new HttpEntity<net.sf.json.JSONObject>(jsonParams, requestHeaders);
	    String result = restTemplate.postForObject(url, requestEntity, String.class);
		return result;
	}
	
	@Deprecated
	public String post(ServletRequest req, String url, Map<String, ?> params) {
		ResponseEntity<String> rss = request(req, url, HttpMethod.POST, params);
	    return rss.getBody();
	}

	public String get(ServletRequest req, String url, Map<String, ?> params) {
		ResponseEntity<String> rss = request(req, url, HttpMethod.GET, params);
	    return rss.getBody();
	}
	
	public String delete(ServletRequest req, String url, Map<String, ?> params) {
		ResponseEntity<String> rss = request(req, url, HttpMethod.DELETE, params);
	    return rss.getBody();
	}
	
	public String put(ServletRequest req, String url, Map<String, ?> params) {
		ResponseEntity<String> rss = request(req, url, HttpMethod.PUT, params);
	    return rss.getBody();
	}
	
	/**
	 * @param req
	 * @param url
	 * @param method	GET方法，参数拼接在url后面
	 * @param params maybe null
	 * @return
	 */
	private ResponseEntity<String> request(ServletRequest req, String url, HttpMethod method, Map<String, ?> params) {
		HttpServletRequest request = (HttpServletRequest) req;
		//拿到header信息
		HttpHeaders requestHeaders = new HttpHeaders();
	    Enumeration<String> headerNames = request.getHeaderNames();
	    while (headerNames.hasMoreElements()) {
	      String key = (String) headerNames.nextElement();
	      String value = request.getHeader(key);
	      requestHeaders.add(key, value);
	    }
	    //获取parameter信息
	    if(params == null) {
	    	params = request.getParameterMap();
	    	String[] paramsArray = params.keySet().toArray(new String[0]);
	    	for(int i=0; i<paramsArray.length; ++i) {
	    		String[] vals = (String[]) params.get(paramsArray[i]);
	    		for(int j=0; j<vals.length; ++j) {
	    			url += (i==0&&j==0 ? "?" : "&") + paramsArray[i] + "=" + vals[j];
	    		}
	    	}
	    } else {
	    	String[] paramsArray = params.keySet().toArray(new String[0]);
	    	for(int i=0; i<paramsArray.length; ++i) {
	    		url += (i==0 ? "?" : "&") + paramsArray[i] + "=" + params.get(paramsArray[i]);
	    	}
	    }
	    
	    HttpEntity<String> requestEntity = new HttpEntity<String>(null, requestHeaders);
	    ResponseEntity<String> rss = restTemplate.exchange(url, method, requestEntity, String.class, params);
		return rss;
	}
	
	public String post(Cookie[] cookies, String url, Map<String, ?> params) {
		ResponseEntity<String> rss = request(cookies, url, HttpMethod.POST, params);
	    return rss.getBody();
	}

	public String get(Cookie[] cookies, String url, Map<String, ?> params) {
		ResponseEntity<String> rss = request(cookies, url, HttpMethod.GET, params);
	    return rss.getBody();
	}
	
	public String delete(Cookie[] cookies, String url, Map<String, ?> params) {
		ResponseEntity<String> rss = request(cookies, url, HttpMethod.DELETE, params);
	    return rss.getBody();
	}
	
	public String put(Cookie[] cookies, String url, Map<String, ?> params) {
		ResponseEntity<String> rss = request(cookies, url, HttpMethod.PUT, params);
	    return rss.getBody();
	}
	
	/**
	 * @param req
	 * @param url
	 * @param method	GET方法，参数拼接在url后面
	 * @param params maybe null
	 * @return
	 */
	private ResponseEntity<String> request(Cookie[] cookies, String url, HttpMethod method, Map<String, ?> params) {
		//拿到header信息
		HttpHeaders requestHeaders = new HttpHeaders();
		if(cookies != null) {
			StringBuilder authority = new StringBuilder();
			for(Cookie cookie : cookies) {
				String name = cookie.getName();
				String value = cookie.getValue();
				if(value == null) continue;
				authority.append(name).append("=").append(value).append(";");
			}
			if(authority.length() > 0) authority.deleteCharAt(authority.length()-1);//去掉末尾的 ;
			requestHeaders.add("authority", authority.toString());
		}
	    if(params != null) {
	    	String[] paramsArray = params.keySet().toArray(new String[0]);
	    	for(int i=0; i<paramsArray.length; ++i) {
	    		url += (i==0 ? "?" : "&") + paramsArray[i] + "=" + params.get(paramsArray[i]);
	    	}
	    } else {
	    	params = new HashMap<String, Object>();
	    }
	    HttpEntity<String> requestEntity = new HttpEntity<String>(null, requestHeaders);
	    ResponseEntity<String> rss = restTemplate.exchange(url, method, requestEntity, String.class, params);
		return rss;
	}
	
	
	private ResponseEntity<String> request(String authority, String url, HttpMethod method, Map<String, ?> params) {
		//拿到header信息
		HttpHeaders requestHeaders = new HttpHeaders();
		requestHeaders.add("authority", authority.toString());
	    if(params != null) {
	    	String[] paramsArray = params.keySet().toArray(new String[0]);
	    	for(int i=0; i<paramsArray.length; ++i) {
	    		url += (i==0 ? "?" : "&") + paramsArray[i] + "=" + params.get(paramsArray[i]);
	    	}
	    } else {
	    	params = new HashMap<String, Object>();
	    }
	    HttpEntity<String> requestEntity = new HttpEntity<String>(null, requestHeaders);
	    ResponseEntity<String> rss = restTemplate.exchange(url, method, requestEntity, String.class, params);
		return rss;
	}
	
	public String post(String authority, String url, Map<String, ?> params) {
		ResponseEntity<String> rss = request(authority, url, HttpMethod.POST, params);
	    return rss.getBody();
	}

	public String get(String authority, String url, Map<String, ?> params) {
		ResponseEntity<String> rss = request(authority, url, HttpMethod.GET, params);
	    return rss.getBody();
	}
	
	public String delete(String authority, String url, Map<String, ?> params) {
		ResponseEntity<String> rss = request(authority, url, HttpMethod.DELETE, params);
	    return rss.getBody();
	}
	
	public String put(String authority, String url, Map<String, ?> params) {
		ResponseEntity<String> rss = request(authority, url, HttpMethod.PUT, params);
	    return rss.getBody();
	}
}
