/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.base.dao.impl;

import com.yyjz.icop.base.dao.impl.BaseDaoImpl;
import com.yyjz.icop.base.entity.AbsIdEntity;
import java.io.Serializable;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class BaseDaoFactoryBean<R extends JpaRepository<T, Serializable>, T>
extends JpaRepositoryFactoryBean<R, T, Serializable> {
    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        return new JpaRepositoryFactory(entityManager){

            protected SimpleJpaRepository<T, Serializable> getTargetRepository(RepositoryInformation information, EntityManager entityManager) {
                Class domainClass = information.getDomainType();
                if (AbsIdEntity.class.isAssignableFrom(domainClass)) {
                    return new BaseDaoImpl(domainClass, entityManager);
                }
                return new SimpleJpaRepository(domainClass, entityManager);
            }

            protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
                return AbsIdEntity.class.isAssignableFrom(metadata.getDomainType()) ? BaseDaoImpl.class : SimpleJpaRepository.class;
            }
        };
    }
}

