/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.base.dao.impl;

import com.yyjz.icop.base.dao.BaseDao;
import com.yyjz.icop.base.tenant.TenantHelper;
import com.yyjz.icop.base.tenant.TenantSpecification;
import com.yyjz.icop.database.entity.SuperEntity;
import java.io.Serializable;
import java.sql.Timestamp;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BaseDaoImpl<T extends SuperEntity>
extends SimpleJpaRepository<T, String>
implements BaseDao<T> {
    private final EntityManager entityManager;
    private JpaEntityInformation<T, ?> entityInformation;

    public BaseDaoImpl(Class<T> domainClass, EntityManager entityManager) {
        super(domainClass, entityManager);
        this.entityManager = entityManager;
    }

    public BaseDaoImpl(JpaEntityInformation<T, Serializable> information, EntityManager entityManager) {
        super(information, entityManager);
        this.entityManager = entityManager;
        this.entityInformation = information;
    }

    public <S extends T> S save(S entity) {
        if (entity != null) {
            TenantHelper.setTenantIdToEntity(entity);
        }
        entity.setAttributeValue("modificationTimestamp", (Object)new Timestamp(System.currentTimeMillis()));
        return (S)((SuperEntity)super.save(entity));
    }

    public void delete(String id) {
        SuperEntity entity = (SuperEntity)this.findOne((Serializable)((Object)id));
        entity.setDr(1);
        this.save((S)entity);
    }

    public void delete(T entity) {
        entity.setDr(1);
        this.save((S)entity);
    }

    @Transactional
    public void deleteInBatch(Iterable<T> entities) {
        if (!entities.iterator().hasNext()) {
            return;
        }
        QueryUtils.applyAndBind((String)QueryUtils.getQueryString((String)"update %s x set dr = 1 ", (String)this.entityInformation.getEntityName()), entities, (EntityManager)this.entityManager).executeUpdate();
    }

    @Transactional
    public void deleteAll() {
        for (SuperEntity t : this.findAll()) {
            t.setDr(1);
            this.save((S)t);
        }
    }

    protected TypedQuery<T> getQuery(Specification<T> spec, Sort sort) {
        return super.getQuery(new TenantSpecification<T>(spec), sort);
    }

    protected TypedQuery<Long> getCountQuery(Specification<T> spec) {
        return super.getCountQuery(new TenantSpecification<T>(spec));
    }

    public T getOne(String id) {
        return (T)((SuperEntity)this.findOne((Serializable)((Object)id)));
    }
}

