/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.base.tenant;

import com.yonyou.iuap.context.InvocationInfoProxy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;

public class TenantHelper {
    private static HashMap<String, TenantMethodCacheItem> tenandIdCache = new HashMap();

    public static String getTenantId() {
        return InvocationInfoProxy.getTenantid();
    }

    private static TenantMethodCacheItem getTeantIdMethod(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> cls = obj.getClass();
        return TenantHelper.getTeantIdMethodByClass(cls);
    }

    private static TenantMethodCacheItem getTeantIdMethodByClass(Class<?> cls) {
        String clsName = cls.getName();
        if (!tenandIdCache.containsKey(clsName)) {
            TenantMethodCacheItem item = new TenantMethodCacheItem();
            item.setReadMethod(TenantHelper.getTenantMethod(cls, "get", new Class[0]));
            item.setWriteMethod(TenantHelper.getTenantMethod(cls, "set", String.class));
            tenandIdCache.put(clsName, item);
        }
        return tenandIdCache.get(clsName);
    }

    private static Method getTenantMethod(Class<?> cls, String method, Class<?> ... paramArrayOfMethod) {
        try {
            return cls.getMethod(method + "TenantId", paramArrayOfMethod);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setTenantIdToEntity(Object entity) {
        TenantMethodCacheItem item = TenantHelper.getTeantIdMethod(entity);
        if (item == null) {
            return;
        }
        Method setMethod = item.getWriteMethod();
        Method getMethod = item.getReadMethod();
        if (setMethod == null || getMethod == null) {
            return;
        }
        try {
            Object oldValue = getMethod.invoke(entity, new Object[0]);
            if (oldValue == null || oldValue.toString() == "") {
                setMethod.invoke(entity, TenantHelper.getTenantId());
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkEntityTeanantId(Object entity) {
        if (entity == null) {
            return true;
        }
        TenantMethodCacheItem method = TenantHelper.getTeantIdMethod(entity);
        if (method.getReadMethod() == null) {
            return true;
        }
        Object tenantId = null;
        try {
            tenantId = method.getReadMethod().invoke(entity, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (tenantId == null) {
            return false;
        }
        return tenantId == TenantHelper.getTenantId();
    }

    public static Predicate getTenantIdPredicate(Root<?> root, CriteriaBuilder cb) {
        Predicate tenantPredicate = null;
        try {
            Path t;
            EntityType model = root.getModel();
            Class cls = model.getJavaType();
            TenantMethodCacheItem item = TenantHelper.getTeantIdMethodByClass(cls);
            if (item.getReadMethod() != null && item.getWriteMethod() != null && (t = root.get("tenantId")) != null) {
                tenantPredicate = cb.equal((Expression)t, (Object)TenantHelper.getTenantId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tenantPredicate;
    }

    private static class TenantMethodCacheItem {
        private Method readMethod;
        private Method writeMethod;

        private TenantMethodCacheItem() {
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public void setReadMethod(Method readMethod) {
            this.readMethod = readMethod;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public void setWriteMethod(Method writeMethod) {
            this.writeMethod = writeMethod;
        }
    }
}

