/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.base.utils;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpUtil {
    private static Logger logger = Logger.getLogger(HttpUtil.class);
    public static final int timeout = 10;

    public static String post(String url) {
        return HttpUtil.post(url, "");
    }

    public static String post(String url, String data) {
        return HttpUtil.httpPost(url, data);
    }

    public static String postJson(String url, String data) {
        return HttpUtil.httpPostJson(url, data);
    }

    public static String post(String url, InputStream instream) {
        try {
            HttpEntity entity = Request.Post((String)url).bodyStream(instream, ContentType.create((String)"text/html", (Charset)Consts.UTF_8)).execute().returnResponse().getEntity();
            return entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : null;
        }
        catch (Exception e) {
            logger.error((Object)("post\u8bf7\u6c42\u5f02\u5e38\uff0c" + e.getMessage() + "\n post url:" + url));
            e.printStackTrace();
            return null;
        }
    }

    public static String get(String url) {
        return HttpUtil.httpGet(url);
    }

    private static String httpPost(String url, String data) {
        try {
            HttpEntity entity = Request.Post((String)url).bodyString(data, ContentType.create((String)"text/html", (Charset)Consts.UTF_8)).execute().returnResponse().getEntity();
            return entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : null;
        }
        catch (Exception e) {
            logger.error((Object)("post\u8bf7\u6c42\u5f02\u5e38\uff0c" + e.getMessage() + "\n post url:" + url));
            e.printStackTrace();
            return null;
        }
    }

    private static String httpPostJson(String url, String data) {
        try {
            HttpEntity entity = Request.Post((String)url).bodyString(data, ContentType.create((String)"application/json", (Charset)Consts.UTF_8)).execute().returnResponse().getEntity();
            return entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : null;
        }
        catch (Exception e) {
            logger.error((Object)("post\u8bf7\u6c42\u5f02\u5e38\uff0c" + e.getMessage() + "\n post url:" + url));
            e.printStackTrace();
            return null;
        }
    }

    public static String postFile(String url, File file) {
        return HttpUtil.postFile(url, null, file);
    }

    public static String postFile(String url, String name, File file) {
        try {
            HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody(name, file).build();
            Request request = Request.Post((String)url);
            request.body(reqEntity);
            HttpEntity resEntity = request.execute().returnResponse().getEntity();
            return resEntity != null ? EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8") : null;
        }
        catch (Exception e) {
            logger.error((Object)("postFile\u8bf7\u6c42\u5f02\u5e38\uff0c" + e.getMessage() + "\n post url:" + url));
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getFile(String url) {
        try {
            Request request = Request.Get((String)url);
            HttpEntity resEntity = request.execute().returnResponse().getEntity();
            return EntityUtils.toByteArray((HttpEntity)resEntity);
        }
        catch (Exception e) {
            logger.error((Object)("postFile\u8bf7\u6c42\u5f02\u5e38\uff0c" + e.getMessage() + "\n post url:" + url));
            e.printStackTrace();
            return null;
        }
    }

    private static String httpGet(String url) {
        try {
            HttpEntity entity = Request.Get((String)url).execute().returnResponse().getEntity();
            return entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : null;
        }
        catch (Exception e) {
            logger.error((Object)("get\u8bf7\u6c42\u5f02\u5e38\uff0c" + e.getMessage() + "\n get url:" + url));
            e.printStackTrace();
            return null;
        }
    }
}

