/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.base.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springside.modules.persistence.DynamicSpecifications;
import org.springside.modules.persistence.SearchFilter;

public final class QueryTool {
    public static final String DEFAULT_SORT = "auto";
    public static final Sort.Direction DESC = Sort.Direction.DESC;
    public static final Sort.Direction ASC = Sort.Direction.ASC;

    public static PageRequest buildPageRequest(int pageNumber, int pageSize, String sortType) {
        Sort sort = null;
        sort = DEFAULT_SORT.equals(sortType) || StringUtils.isBlank((String)sortType) ? new Sort(Sort.Direction.DESC, new String[]{"modificationTimestamp"}) : new Sort(Sort.Direction.ASC, new String[]{sortType});
        return new PageRequest(pageNumber - 1, pageSize, sort);
    }

    public static PageRequest buildPageRequest(int pageNumber, int pageSize, String ... sortType) {
        Sort sort = null;
        sort = new Sort(Sort.Direction.ASC, sortType);
        return new PageRequest(pageNumber - 1, pageSize, sort);
    }

    public static <T> Specification<T> buildSpecification(Map<String, Object> searchParams, Class<T> domainClass) {
        Map filters = SearchFilter.parse(searchParams);
        Specification spec = DynamicSpecifications.bySearchFilter(filters.values(), domainClass);
        return spec;
    }

    public static void split(String originstring, List<String> ret, String ... spliters) {
        String sp = spliters[0];
        String[] arr = originstring.split(sp);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(spliters));
        list.remove(sp);
        spliters = list.toArray(new String[spliters.length - 1]);
        list = null;
        for (String str : arr) {
            if (spliters.length == 0 || !QueryTool.more(str, spliters)) {
                ret.add(str);
                continue;
            }
            if (spliters.length == 0) {
                return;
            }
            QueryTool.split(str, ret, spliters);
        }
    }

    private static boolean more(String str, String ... flags) {
        boolean ret = false;
        for (String flg : flags) {
            if (str.indexOf(flg) == -1) continue;
            ret |= true;
            break;
        }
        return ret;
    }

    public static Map<String, Object> parseCondition(String relyCondition, String[] split) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (relyCondition != null) {
            ArrayList<String> conditions = new ArrayList<String>();
            QueryTool.split(relyCondition, conditions, split);
            String[] kv = null;
            for (String cond : conditions) {
                if (cond.indexOf("=") != -1) {
                    kv = cond.split("=");
                    map.put(SearchFilter.Operator.EQ + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
                    continue;
                }
                if (cond.indexOf("like") != -1) {
                    kv = cond.split("like");
                    map.put(SearchFilter.Operator.LIKE + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
                    continue;
                }
                if (cond.indexOf("LIKE") != -1) {
                    kv = cond.split("LIKE");
                    map.put(SearchFilter.Operator.LIKE + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
                    continue;
                }
                if (cond.indexOf(">") != -1) {
                    kv = cond.split(">");
                    map.put(SearchFilter.Operator.GT + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
                    continue;
                }
                if (cond.indexOf(">=") != -1) {
                    kv = cond.split(">=");
                    map.put(SearchFilter.Operator.GTE + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
                    continue;
                }
                if (cond.indexOf("<") != -1) {
                    kv = cond.split("<");
                    map.put(SearchFilter.Operator.LT + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
                    continue;
                }
                if (cond.indexOf("<=") == -1) continue;
                kv = cond.split("<=");
                map.put(SearchFilter.Operator.LTE + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
            }
        }
        return map;
    }

    public static Map<String, Object> parseCondition(String relyCondition) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (relyCondition != null) {
            ArrayList<String> conditions = new ArrayList<String>();
            QueryTool.split(relyCondition, conditions, "and");
            String[] kv = null;
            for (String cond : conditions) {
                if (cond.indexOf("=") != -1) {
                    kv = cond.split("=");
                    map.put(SearchFilter.Operator.EQ + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
                    continue;
                }
                if (cond.indexOf("like") != -1) {
                    kv = cond.split("like");
                    map.put(SearchFilter.Operator.LIKE + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
                    continue;
                }
                if (cond.indexOf("LIKE") != -1) {
                    kv = cond.split("LIKE");
                    map.put(SearchFilter.Operator.LIKE + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
                    continue;
                }
                if (cond.indexOf(">") != -1) {
                    kv = cond.split(">");
                    map.put(SearchFilter.Operator.GT + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
                    continue;
                }
                if (cond.indexOf(">=") != -1) {
                    kv = cond.split(">=");
                    map.put(SearchFilter.Operator.GTE + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
                    continue;
                }
                if (cond.indexOf("<") != -1) {
                    kv = cond.split("<");
                    map.put(SearchFilter.Operator.LT + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
                    continue;
                }
                if (cond.indexOf("<=") == -1) continue;
                kv = cond.split("<=");
                map.put(SearchFilter.Operator.LTE + "_" + org.apache.commons.lang3.StringUtils.trim((String)kv[0]), org.apache.commons.lang3.StringUtils.trim((String)kv[1]));
            }
        }
        return map;
    }
}

