/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.file.fastdfs;

import java.io.File;
import java.io.FileNotFoundException;
import javax.servlet.http.HttpServletRequest;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.StorageClient1;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastdfsClient {
    public static Logger logger = LoggerFactory.getLogger(FastdfsClient.class);
    private String PATH = "/config/";
    private String FAST_CLIENT_CONF = "fdfs_client.conf";
    private static volatile FastdfsClient fdfsClient;
    private TrackerClient tracker;

    private FastdfsClient(HttpServletRequest request) {
        try {
            File file = new File(Thread.currentThread().getContextClassLoader().getResource("/") + this.FAST_CLIENT_CONF);
            String path = "";
            if (file.exists()) {
                path = file.getAbsolutePath();
            } else {
                file = new File(Thread.currentThread().getContextClassLoader().getResource("/").toURI());
                if (file.getParent() != null) {
                    path = file.getParent();
                }
                path = path + this.PATH + this.FAST_CLIENT_CONF;
            }
            logger.error("fastdfs\u914d\u7f6e\u6587\u4ef6\u5730\u5740\uff1a" + path);
            ClientGlobal.init((String)path);
            this.tracker = new TrackerClient();
        }
        catch (FileNotFoundException e) {
            logger.error("\u672a\u627e\u5230fdfs\u5bf9\u5e94\u7684\u914d\u7f6e\u6587\u4ef6!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316FastdfsClient\u62a5\u9519!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FastdfsClient getInstance(HttpServletRequest request) {
        if (fdfsClient != null) return fdfsClient;
        Class<FastdfsClient> clazz = FastdfsClient.class;
        synchronized (FastdfsClient.class) {
            if (fdfsClient != null) return fdfsClient;
            fdfsClient = new FastdfsClient(request);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return fdfsClient;
        }
    }

    public String upload(String localFilePath) throws Exception {
        return this.upload(localFilePath, null);
    }

    public String upload(byte[] fileContent) throws Exception {
        return this.upload(fileContent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(String localFilePath, NameValuePair[] metaData) throws Exception {
        TrackerServer trackerServer = null;
        StorageClient1 storageClient = null;
        String master_file_id = null;
        try {
            trackerServer = this.tracker.getConnection();
            StorageServer storageServer = null;
            storageClient = new StorageClient1(trackerServer, storageServer);
            master_file_id = storageClient.upload_file1(localFilePath, null, metaData);
        }
        finally {
            if (trackerServer != null) {
                trackerServer.close();
            }
        }
        return master_file_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(byte[] fileContent, NameValuePair[] metaData) throws Exception {
        TrackerServer trackerServer = null;
        StorageClient1 storageClient = null;
        String master_file_id = null;
        try {
            trackerServer = this.tracker.getConnection();
            StorageServer storageServer = null;
            storageClient = new StorageClient1(trackerServer, storageServer);
            master_file_id = storageClient.upload_file1(fileContent, "jpg", metaData);
        }
        finally {
            if (trackerServer != null) {
                trackerServer.close();
            }
        }
        return master_file_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameValuePair[] getMetaData(String fileId) throws Exception {
        TrackerServer trackerServer = null;
        StorageClient1 storageClient = null;
        NameValuePair[] nvPair = null;
        try {
            trackerServer = this.tracker.getConnection();
            StorageServer storageServer = null;
            storageClient = new StorageClient1(trackerServer, storageServer);
            nvPair = storageClient.get_metadata1(fileId);
        }
        finally {
            if (trackerServer != null) {
                trackerServer.close();
            }
        }
        return nvPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String fileId) throws Exception {
        TrackerServer trackerServer = null;
        StorageClient1 storageClient = null;
        boolean success = false;
        try {
            trackerServer = this.tracker.getConnection();
            StorageServer storageServer = null;
            storageClient = new StorageClient1(trackerServer, storageServer);
            if (storageClient.delete_file1(fileId) == 0) {
                success = true;
            }
        }
        finally {
            if (trackerServer != null) {
                trackerServer.close();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] download(String fileId) throws Exception {
        TrackerServer trackerServer = null;
        StorageClient1 storageClient = null;
        byte[] fileContent = null;
        try {
            trackerServer = this.tracker.getConnection();
            StorageServer storageServer = null;
            storageClient = new StorageClient1(trackerServer, storageServer);
            fileContent = storageClient.download_file1(fileId);
        }
        finally {
            if (trackerServer != null) {
                trackerServer.close();
            }
        }
        return fileContent;
    }
}

