/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.file.fastdfs;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.file.IFileTool;
import com.yyjz.icop.file.fastdfs.FastdfsClient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class FastdfsTool
implements IFileTool {
    public static Logger logger = LoggerFactory.getLogger(FastdfsTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(HttpServletRequest request, HttpServletResponse response) {
        String fdfsid = request.getParameter("id");
        response.setContentType("image/jpg;charset=utf-8");
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            byte[] contents = FastdfsClient.getInstance(request).download(fdfsid);
            if (contents == null) {
                logger.error("\u6ca1\u6709\u627e\u5230\u56fe\u7247\u5185\u5bb9\uff01");
                return;
            }
            bis = new BufferedInputStream(new ByteArrayInputStream(contents));
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (Exception e) {
            logger.error("no pic load", (Throwable)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    logger.error("bis close exception", (Throwable)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error("bos close exception", (Throwable)e);
                }
            }
        }
    }

    @Override
    public JSONObject upload(HttpServletRequest request) {
        return this.upload(request, 0x300000L);
    }

    @Override
    public JSONObject upload(HttpServletRequest request, long limitSize) {
        ArrayList<String> fileName = new ArrayList<String>();
        JSONObject jsonObj = new JSONObject();
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                MultipartFile file = multiRequest.getFile(((String)iter.next()).toString());
                if (file.getSize() > limitSize) {
                    jsonObj.put("fileIds", (Object)"-1");
                    jsonObj.put("fileErr", (Object)("\u4e0a\u4f20\u56fe\u7247\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7" + limitSize + "M"));
                    return jsonObj;
                }
                if (file == null) continue;
                try {
                    FastdfsClient client = FastdfsClient.getInstance(request);
                    fileName.add(client.upload(file.getBytes()));
                }
                catch (IllegalStateException e) {
                    logger.error("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef", (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    logger.error("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef", (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (Exception e) {
                    logger.error("\u4e0a\u4f20\u6587\u4ef6\u5230fdfs\u9519\u8bef", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
        jsonObj.put("fileIds", fileName);
        return jsonObj;
    }
}

