/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ReferTreeData {
    private String id;
    private String code;
    private String name;
    private Boolean isLeaf;
    private List<ReferTreeData> children;
    private Object extdata;
    private boolean selectable = true;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getIsLeaf() {
        return this.isLeaf;
    }

    public void setIsLeaf(Boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public List<ReferTreeData> getChildren() {
        return this.children;
    }

    public void setChildren(List<ReferTreeData> children) {
        this.children = children;
    }

    public Object getExtdata() {
        return this.extdata;
    }

    public void setExtdata(Object extdata) {
        this.extdata = extdata;
    }

    public boolean getSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean addChild(ReferTreeData child) {
        if (null == this.children) {
            this.children = new ArrayList<ReferTreeData>();
        }
        return this.children.add(child);
    }

    public boolean addChildren(List<ReferTreeData> children) {
        if (null == this.children) {
            this.children = children;
            return true;
        }
        return this.children.addAll(children);
    }

    public static boolean judgeInnerCode(String innerCode) {
        if (StringUtils.isBlank((String)innerCode)) {
            return false;
        }
        if (innerCode.length() % 4 != 0) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]+");
        Matcher matcher = pattern.matcher(innerCode);
        return matcher.matches();
    }
}

