/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtil {
    private RestTemplate restTemplate = new RestTemplate();

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String _post(ServletRequest req, String url, Map<String, ?> params) {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(MediaType.APPLICATION_JSON);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            requestHeaders.add(key, value);
        }
        JSONObject jsonParams = JSONObject.fromObject(params);
        HttpEntity requestEntity = new HttpEntity((Object)jsonParams, (MultiValueMap)requestHeaders);
        String result = (String)this.restTemplate.postForObject(url, (Object)requestEntity, String.class, new Object[0]);
        return result;
    }

    public String post(ServletRequest req, String url, Object params, MediaType mediaType) {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(mediaType);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            requestHeaders.add(key, value);
        }
        JSONObject jsonParams = JSONObject.fromObject((Object)params);
        HttpEntity requestEntity = new HttpEntity((Object)jsonParams, (MultiValueMap)requestHeaders);
        String result = (String)this.restTemplate.postForObject(url, (Object)requestEntity, String.class, new Object[0]);
        return result;
    }

    @Deprecated
    public String post(ServletRequest req, String url, Map<String, ?> params) {
        ResponseEntity<String> rss = this.request(req, url, HttpMethod.POST, params);
        return (String)rss.getBody();
    }

    public String get(ServletRequest req, String url, Map<String, ?> params) {
        ResponseEntity<String> rss = this.request(req, url, HttpMethod.GET, params);
        return (String)rss.getBody();
    }

    public String delete(ServletRequest req, String url, Map<String, ?> params) {
        ResponseEntity<String> rss = this.request(req, url, HttpMethod.DELETE, params);
        return (String)rss.getBody();
    }

    public String put(ServletRequest req, String url, Map<String, ?> params) {
        ResponseEntity<String> rss = this.request(req, url, HttpMethod.PUT, params);
        return (String)rss.getBody();
    }

    private ResponseEntity<String> request(ServletRequest req, String url, HttpMethod method, Map<String, ?> params) {
        int i;
        String[] paramsArray;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpHeaders requestHeaders = new HttpHeaders();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            requestHeaders.add(key, value);
        }
        if (params == null) {
            params = request.getParameterMap();
            paramsArray = params.keySet().toArray(new String[0]);
            for (i = 0; i < paramsArray.length; ++i) {
                String[] vals = (String[])params.get(paramsArray[i]);
                for (int j = 0; j < vals.length; ++j) {
                    url = url + (i == 0 && j == 0 ? "?" : "&") + paramsArray[i] + "=" + vals[j];
                }
            }
        } else {
            paramsArray = params.keySet().toArray(new String[0]);
            for (i = 0; i < paramsArray.length; ++i) {
                url = url + (i == 0 ? "?" : "&") + paramsArray[i] + "=" + params.get(paramsArray[i]);
            }
        }
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)requestHeaders);
        ResponseEntity rss = this.restTemplate.exchange(url, method, requestEntity, String.class, params);
        return rss;
    }

    public String post(Cookie[] cookies, String url, Map<String, ?> params) {
        ResponseEntity<String> rss = this.request(cookies, url, HttpMethod.POST, params);
        return (String)rss.getBody();
    }

    public String get(Cookie[] cookies, String url, Map<String, ?> params) {
        ResponseEntity<String> rss = this.request(cookies, url, HttpMethod.GET, params);
        return (String)rss.getBody();
    }

    public String delete(Cookie[] cookies, String url, Map<String, ?> params) {
        ResponseEntity<String> rss = this.request(cookies, url, HttpMethod.DELETE, params);
        return (String)rss.getBody();
    }

    public String put(Cookie[] cookies, String url, Map<String, ?> params) {
        ResponseEntity<String> rss = this.request(cookies, url, HttpMethod.PUT, params);
        return (String)rss.getBody();
    }

    private ResponseEntity<String> request(Cookie[] cookies, String url, HttpMethod method, Map<String, ?> params) {
        HttpHeaders requestHeaders = new HttpHeaders();
        if (cookies != null) {
            StringBuilder authority = new StringBuilder();
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                String value = cookie.getValue();
                if (value == null) continue;
                authority.append(name).append("=").append(value).append(";");
            }
            if (authority.length() > 0) {
                authority.deleteCharAt(authority.length() - 1);
            }
            requestHeaders.add("authority", authority.toString());
        }
        if (params != null) {
            String[] paramsArray = params.keySet().toArray(new String[0]);
            for (int i = 0; i < paramsArray.length; ++i) {
                url = url + (i == 0 ? "?" : "&") + paramsArray[i] + "=" + params.get(paramsArray[i]);
            }
        } else {
            params = new HashMap();
        }
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)requestHeaders);
        ResponseEntity rss = this.restTemplate.exchange(url, method, requestEntity, String.class, params);
        return rss;
    }

    private ResponseEntity<String> request(String authority, String url, HttpMethod method, Map<String, ?> params) {
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.add("authority", authority.toString());
        if (params != null) {
            String[] paramsArray = params.keySet().toArray(new String[0]);
            for (int i = 0; i < paramsArray.length; ++i) {
                url = url + (i == 0 ? "?" : "&") + paramsArray[i] + "=" + params.get(paramsArray[i]);
            }
        } else {
            params = new HashMap();
        }
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)requestHeaders);
        ResponseEntity rss = this.restTemplate.exchange(url, method, requestEntity, String.class, params);
        return rss;
    }

    public String post(String authority, String url, Map<String, ?> params) {
        ResponseEntity<String> rss = this.request(authority, url, HttpMethod.POST, params);
        return (String)rss.getBody();
    }

    public String get(String authority, String url, Map<String, ?> params) {
        ResponseEntity<String> rss = this.request(authority, url, HttpMethod.GET, params);
        return (String)rss.getBody();
    }

    public String delete(String authority, String url, Map<String, ?> params) {
        ResponseEntity<String> rss = this.request(authority, url, HttpMethod.DELETE, params);
        return (String)rss.getBody();
    }

    public String put(String authority, String url, Map<String, ?> params) {
        ResponseEntity<String> rss = this.request(authority, url, HttpMethod.PUT, params);
        return (String)rss.getBody();
    }
}

