package com.yyjz.icop.base.expression;

import java.util.Map;

import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

/**
 * 基于 SpEL 表达式计算辅助类
 * @author jiangsf
 *
 */
public class ExpressionHelper {
	//static final MetadataPropertyAccessor metadataAccessor = new MetadataPropertyAccessor();
	static final JsonObjectPropertyAccessor jsonAccessor = new JsonObjectPropertyAccessor();
	
	/**
	 * 计算表达式
	 * @param expr 表达式
	 * @return 表达式计算结果
	 */
	public static Object getValue(String expr){
		return getValue(expr,null,null);
	}
	
	
	/**
	 * 计算表达式
	 * @param expr 表达式
	 * @param variables 变量
	 * @return 表达式计算结果
	 */
	public static Object getValue(String expr,Map<String,Object> variables){
		return getValue(expr,null,variables);
	}

	/**
	 * 计算表达式
	 * @param expr 表达式
	 * @param rootObject 需要计算的对象
	 * @return 表达式计算结果
	 */
	public static Object getValue(String expr,Object rootObject){
		return getValue(expr,rootObject,null);
	}
		 
	
	/**
	 * 计算表达式
	 * @param expr 表达式
	 * @param rootObject 需要计算的对象
	 * @param variables 变量
	 * @return 表达式计算结果
	 */
	public static Object getValue(String expr,Object rootObject,Map<String,Object> variables){
		 
		StandardEvaluationContext context= new ICOPEvaluationContext();
		
		 //设置当前表达式计算变量
		 if(variables!=null&&variables.size()>0){
			 context.setVariables(variables);
		 }
		 //基于元数据的属性访问器
		 //context.addPropertyAccessor(metadataAccessor);
		 //增加JsonObject属性访问器
		 context.addPropertyAccessor(jsonAccessor);
		 
		 context.setRootObject(rootObject);
		 //表达式解析和计算
		 ExpressionParser parser= new SpelExpressionParser();
		 Expression exp= parser.parseExpression(expr);
		 return exp.getValue(context);
	}
}
