package com.yyjz.icop.base.expression;

import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;

import com.alibaba.fastjson.JSONObject;
/**
 * Json 属性访问器
 * @author jiangsf
 *
 */
class JsonObjectPropertyAccessor implements PropertyAccessor{

	public Class<?>[] getSpecificTargetClasses() {
		
		return new Class<?>[]{JSONObject.class};
	}

	public boolean canRead(EvaluationContext context, Object target, String name)
			throws AccessException {
		if(target==null) return false;
		if(target instanceof JSONObject) return true;
		return false;
	}

	public TypedValue read(EvaluationContext context, Object target, String name)
			throws AccessException {
		if(target == null) return null;
		if(!(target instanceof JSONObject)) return null;
		JSONObject json= (JSONObject)target;
		Object value = json.get(name);
		return new TypedValue(value);
	}

	public boolean canWrite(EvaluationContext context, Object target,
			String name) throws AccessException {
		if(target==null) return false;
		if(target instanceof JSONObject) return true;
		return false;
	}

	public void write(EvaluationContext context, Object target, String name,
			Object newValue) throws AccessException {
		if(target==null) return ;
		if(!(target instanceof JSONObject)) return ;
		
		JSONObject json= (JSONObject)target;
		json.put(name, newValue);
	}

}
