package com.yyjz.icop.base.tenant;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.commons.dbcp.BasicDataSource;

/**
 * 多租户数据源，默认情况下Schema名为租户ID
 * @author jiangsf
 *
 */
public class TenantDataSource  extends BasicDataSource {

	@Override
	public Connection getConnection() throws SQLException {
		Connection con = super.getConnection();
		chanageCatalog(con);
		return con;
	}

	@Override
	public Connection getConnection(String username, String password) throws SQLException {
		Connection con = super.getConnection(username, password);
		chanageCatalog(con);
		return con;
	}
	
	/**
	 * 切换Schema
	 * @param con
	 * @throws SQLException
	 */
	protected void chanageCatalog(Connection con) throws SQLException{
		con.setCatalog(TenantHelper.getTenantId()); //切换Schema
	}
}

