/**
 * $文件说明$
 *
 * @author Alex
 * @version 
 * @see
 * @since
 * @time 2016年4月29日 下午5:25:32
 */
package com.yyjz.icop.base.vo.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;



/**
 * <p>
 * 本类主要功能：多叉树公共工具类
 * <p>
 * @version YYCC_V1.0
 * @author yujian1
 * @time 2016年4月29日 下午5:25:32
 */
public class MultipleTree {
	public static String getTree(List<? extends SuperTreeVO> dataList) {
		// 节点列表（映射表，用于临时存储节点对象）
		HashMap<String,SuperTreeVO> innercodeMap = new HashMap<String,SuperTreeVO>();
		
		Iterator<? extends SuperTreeVO> it = dataList.iterator();
		while(it.hasNext())
		{
			SuperTreeVO tree=it.next();
			innercodeMap.put(tree.getInnercode(),tree);   
		}
		
		// 根节点
		SuperTreeVO root = null;
		Iterator<? extends SuperTreeVO> itRoot = dataList.iterator();
		List<SuperTreeVO> rootList =new ArrayList<SuperTreeVO>();
		while(itRoot.hasNext())
		{
			SuperTreeVO vo=itRoot.next();
			if (vo.getInnercode().length()== 4) {
				root = vo;
				rootList.add(root);
			} else {
				// 当从树中间截取一部分作为新树时（根的innercode不是四位时），获取根节点操作
				if(innercodeMap.get(vo.getInnercode().substring(0, vo.getInnercode().length()-4))==null){
					rootList.add(vo);
				}
				else{
					innercodeMap.get(vo.getInnercode().substring(0, vo.getInnercode().length()-4)).addChild(vo);
				}
			}
		}
		for(SuperTreeVO roottree :rootList){
			// 对多叉树进行横向排序
			roottree.sortChildren();
		}
		
		return rootList.toString();
	}
}
