package com.yyjz.icop.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ContextLoader;

import com.alibaba.fastjson.JSONObject;
import com.yonyou.iuap.auth.session.SessionManager;
import com.yonyou.iuap.auth.token.ITokenProcessor;
import com.yonyou.iuap.auth.token.TokenFactory;
import com.yonyou.iuap.auth.token.TokenParameter;
import com.yonyou.iuap.utils.CookieUtil;
import com.yyjz.icop.base.response.ReturnCode;

public class AuthenticationFilter implements Filter {
	public static Logger logger = LoggerFactory.getLogger(AuthenticationFilter.class);

	private TokenFactory tokenFactory = (TokenFactory) ContextLoader.getCurrentWebApplicationContext().getBean("tokenFactory");
	private SessionManager sessionManager = (SessionManager) ContextLoader.getCurrentWebApplicationContext().getBean("sessionManager");
	
	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
	}
	
	@Override
	public void doFilter(ServletRequest req, ServletResponse res,
			FilterChain chain) throws IOException, ServletException {
		HttpServletRequest request = (HttpServletRequest) req;
		Cookie[] cookies = generateCookiesFromHeadersOrParameter(request);
		String userId = (String) CookieUtil.findCookieValue(cookies, "u_usercode");
		String tokenStr = CookieUtil.findCookieValue(cookies, "token");
		if (!(userId == null || tokenStr == null)) {//参考 StatelessRealm 中的 doGetAuthenticationInfo方法
			try {
				//参考 StatelessAuthcFilter中的 onAccessDenied方法
				ITokenProcessor tokenProcessor = this.tokenFactory.getTokenProcessor(tokenStr);
				//参考 StatelessRealm 中的 doGetAuthenticationInfo方法
				TokenParameter tp = tokenProcessor.getTokenParameterFromCookie(cookies);
				tokenStr = tokenProcessor.generateToken(tp);
				if(!this.sessionManager.validateOnlineSession(userId, tokenStr)) {
					authenticationFail(res, userId);
				} else {
					chain.doFilter(req, res);
				}
			} catch(Exception e) {
				e.printStackTrace();
				authenticationFail(res, userId);
			}
		} else {
			chain.doFilter(req, res);
		}
	}

	/**
	 * @param res
	 * @param userId
	 * @throws IOException
	 */
	private void authenticationFail(ServletResponse res, String userId) throws IOException {
		res.setCharacterEncoding("UTF-8");
		JSONObject ret = new JSONObject();
		ret.put("code", ReturnCode.FAILURE.getValue());
		ret.put("msg", "Check_*_: User " + (userId != null ? userId : "") + " authenticate fail in System, maybe session timeout!");
		res.getOutputStream().write(ret.toJSONString().getBytes());
		res.flushBuffer();
	}
	
	private Cookie[] generateCookiesFromHeadersOrParameter(HttpServletRequest request) {
		List<Cookie> cookies = new ArrayList<Cookie>();
		String icop_token = request.getParameter("icop-token");
		if(icop_token == null) icop_token = request.getHeader("icop-token");
		
		String icop_authentication_fileds = request.getParameter("icop-authentication-fileds");
		if(icop_authentication_fileds == null) icop_authentication_fileds = request.getHeader("icop-authentication-fileds");
		
		if(icop_token != null) {
			cookies.add(new Cookie("token", icop_token));
		}
		if(icop_authentication_fileds != null) {
			String[] fields = {"u_usercode", "u_logints", "tenantid", "userType", "typeAlias"}; 
			String[] authenticationFields = icop_authentication_fileds.split(",");
			for(int i=0; i<authenticationFields.length; ++i) {
				cookies.add(new Cookie(fields[i], authenticationFields[i]));
			}
			cookies.add(new Cookie("userId", authenticationFields[0]));
		}
		
		return cookies.toArray(new Cookie[cookies.size()]);
	}
	
	@Override
	public void destroy() {
	}
}