package com.yyjz.icop.orgcenter.commons;

import com.yyjz.icop.base.exception.BusinessException;

public enum OrgCategory{
	ORG_UNIT("9000", "组织单元"),
	ORG_ADMIN("9001", "行政"),
	ORG_CORPORATE("0001", "法人"), 
	ORG_HR("0002", "人力资源"), 
	ORG_INVESTMENT("0003", "投资"), 
	ORG_FINANCE("0004", "资金"), 
	ORG_PROCUREMENT("0005", "采购"), 
	ORG_TAX("0006", "税务"), 
	ORG_ISFINANCE("0007", "财务"), 
	ORG_DISCIPLINE("0008", "纪检"), 
	ORG_FINANCE_AUDIT("0009", "财务审计"), 
	ORG_CONSTRUCT("0010", "建造"), 
	ORG_AGREEMENT("0011", "合约");

	OrgCategory(String code, String name){
		this.code = code;
		this.name = name;
	}

	private String code;
	private String name;

	public String getCode(){
		return code;
	}

	public String getName(){
		return name;
	}

	public static OrgCategory getInstance(String code) throws BusinessException{
		for(OrgCategory category : OrgCategory.values()){
			if(category.getCode().equals(code)){
				return category;
			}
		}
		throw new BusinessException("非法职能组织");
	}

	public static String getCode(String name) throws BusinessException{
		for(OrgCategory category : OrgCategory.values()){
			if(category.getName().equals(name)){
				return category.getCode();
			}
		}
		throw new BusinessException("非法职能组织");
	}
	
	public static String getName(String code) throws BusinessException{
		for(OrgCategory category : OrgCategory.values()){
			if(category.getCode().equals(code)){
				return category.getName();
			}
		}
		throw new BusinessException("非法职能组织");
	}
	
	public static boolean check(String code){
		for(OrgCategory category : OrgCategory.values()){
			if(code.equals(category.getCode())){
				return true;
			}
		}
		
		return false;
	}
}
