package com.yyjz.icop.orgcenter.commons;

import java.util.ArrayList;
import java.util.List;

public enum OrgStatus{
	INIT("初始化", -1), ENABLED("启用", 0), DISABLED("停用", 1);
	
	OrgStatus(String displayName, int status) {
		this.displayName = displayName;
		this.status = status;
	}
	
	private String displayName;
	private int status;

	public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
	
	public static String getDisplayName(int status){
		for(OrgStatus orgStatus : OrgStatus.values()){
			if(orgStatus.getStatus() == status){
				return orgStatus.getDisplayName();
			}
		}
		return null;
	}
	
	public static int getStatus(String displayName){
		for(OrgStatus orgStatus : OrgStatus.values()){
			if(orgStatus.getDisplayName().equals(displayName)){
				return orgStatus.getStatus();
			}
		}
		return -1;
	}
	
	public static boolean check(int status){
		for(OrgStatus orgStatus : OrgStatus.values()){
			if(orgStatus.getStatus() == status){
				return true;
			}
		}
		return false;
	}
	
	public static boolean check(List<Integer> statuses){
		if(null == statuses || statuses.size() == 0){
			return false;
		}
		for(int status : statuses){
			if(!check(status)){
				return false;
			}
		}
		
		return true;
	}
	
	public static List<Integer> getAllStatus(){
		List<Integer> list = new ArrayList<>(3);
		for(OrgStatus orgStatus : OrgStatus.values()){
			list.add(orgStatus.getStatus());
		}
		
		return list;
	}
}
