package com.yyjz.icop.orgcenter.commons;

public enum OrgType{
	GROUP("集团", "1"), 
	SUB_COMP("分/子公司）", "2"), 
	PROJECT_DEPT("项目部", "3"),
	VIRTUAL_DEPT("虚拟部门", "4"),
	COMP("公司", "5"),
	MANAGER_DEPT("经理部", "6"),
	
	ORG_UNIT("组织单元", "-1");
	
	OrgType(String displayName, String type) {
		this.displayName = displayName;
		this.type = type;
	}
	
	private String displayName;
	private String type;

	public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
	
	public static String getDisplayName(String type){
		for(OrgType orgType : OrgType.values()){
			if(orgType.getType().equals(type)){
				return orgType.getDisplayName();
			}
		}
		return null;
	}
	
	public static String getType(String displayName){
		for(OrgType orgType : OrgType.values()){
			if(orgType.getDisplayName().equals(displayName)){
				return orgType.getType();
			}
		}
		return null;
	}
}
