package com.yyjz.icop.orgcenter.company.service;

import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.orgcenter.company.vo.CompanyVO;
import com.yyjz.icop.util.ReferTreeData;

import java.util.List;

/**
 * 基础组织service:查询时添加enabled参数
 * @Description: 基础组织service:查询时添加enabled参数
 * @Author: zhangxn
 * @CreateDate: 2018/3/22 10:33
 */
public interface ICompanyEnabledService {
		/**
		 * <p>查询根组织</p>
		 * @param enabled 是否启用 0：启用 1：停用 其他：全部
		 * @return com.yyjz.icop.orgcenter.company.vo.CompanyVO
		 * @author zhangxn
		 * @date 2018/3/21 16:16
		 */
		public CompanyVO queryRootCompany(int enabled);

		/**
		 * <p>获取所有基础组织</p>
		 * @param enabled 是否启用 0：启用 1：停用 其他：全部
		 * @return java.util.List<com.yyjz.icop.orgcenter.company.vo.CompanyVO>
		 * @author zhangxn
		 * @date 2018/3/22 9:29
		 */
		public List<CompanyVO> getAllCompany(int enabled);

		/**
		 * <p>根据组织名称或code模糊查询</p> <p style="color:red">注意：返回结果包括本下和本上，为完整的树</p>
		 * @param key 搜索关键字 名称或code
		 * @param enabled 是否启用 0：启用 1：停用 其他：全部
		 * @return java.util.List<com.yyjz.icop.orgcenter.company.vo.CompanyVO>
		 * @author zhangxn
		 * @date 2018/3/22 9:39
		 */
		public List<CompanyVO> getCompanysByName(String key, int enabled);

		/**
		 * <p>根据组织ID获取所有孩子节点</p> <p style="color:red">注意：一次性加载所有自己点</p>
		 * @param id 组织ID
		 * @param enabled 是否启用 0：启用 1：停用 其他：全部
		 * @return java.util.List<com.yyjz.icop.orgcenter.company.vo.CompanyVO>
		 * @author zhangxn
		 * @date 2018/3/21 17:08
		 */
		public List<CompanyVO> queryAllChildren(String id, int enabled);
		/**
		 * <p>根据pid获取所有一级子节点：数据中不包含是否包含下级组织</p>
		 * @param companyId 组织ID
		 * @param enabled 是否启用 0：启用 1：停用 其他：全部
		 * @return java.util.List<com.yyjz.icop.orgcenter.company.vo.CompanyVO>
		 * @author zhangxn
		 * @date 2018/3/22 10:58
		 */
		public List<CompanyVO> queryNextChildren(String companyId, int enabled);

		/**
		 * <p>根据pid获取所有一级子节点：数据中包含是否包含下级组织</p>
		 * @param pid 基础组织父ID
		 * @param enabled 是否启用 0：启用 1：停用 其他：全部
		 * @return java.util.List<com.yyjz.icop.orgcenter.company.vo.CompanyVO>
		 * @throws
		 * @author zhangxn
		 * @date 2018/3/21 16:34
		 */
		public List<CompanyVO> queryCompanyByPid(String pid, int enabled);

		/**
		 * <p>获取本上级基础组织</p> <p style="color:red">注意：包括本级</p>
		 * @param id 基础组织ID
		 * @param enabled 是否启用 0：启用 1：停用 其他：全部
		 * @return java.util.List<com.yyjz.icop.orgcenter.company.vo.CompanyVO>
		 * @author zhangxn
		 * @date 2018/3/21 18:27
		 */
		public List<CompanyVO> queryAllParents(String id, int enabled);
		/**
		 * <p>根据code查询基础组织</p>
		 * @param companyCode code
		 * @param enabled 是否启用 0：启用 1：停用 其他：全部
		 * @return com.yyjz.icop.orgcenter.company.vo.CompanyVO
		 * @author zhangxn
		 * @date 2018/3/22 15:04
		 */
		public CompanyVO findCompanyByCode(String companyCode,int enabled);
		/**
		 * <p>根据当前节点ID获取一级公司和部门</p>
		 * <p style="color:red">注意：当前节点可能是组织或部门</p>
		 * @param pid 节点ID
		 * @param isDept 当前节点是否部门
		 * @param enabled 是否启用 0：启用 1：停用 其他：全部
		 * @return java.util.List<com.yyjz.icop.util.ReferTreeData>
		 * @author zhangxn
		 * @date 2018/3/22 15:10
		 */
		public List<ExtReferTreeData> queryCompanyAndDeptByPid(String pid, boolean isDept,int enabled);

		List<ReferTreeData> getObjectCompanysAndDepts(String companyId,String selectable,int enabled) throws BusinessException;
		List<ReferTreeData> getObjectCompanysAndDeptsByCompanyCode(String companyCode,int enabled) throws BusinessException;
		List<ReferTreeData> getObjectCompanysAndDeptsNew(String selectable,int enabled)  throws BusinessException;
		List<ReferTreeData> getObjectCompanysAndDeptsByCompanyCode(String companyCode, String selectable,int enabled) throws BusinessException;

		public List<ExtReferTreeData> searchCompanyAndDeptByPid(String pid, boolean b, int enabled, String searchText);
}
