package com.yyjz.icop.orgcenter.company.service;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.base.response.MapResponse;
import com.yyjz.icop.orgcenter.company.vo.CompanyVO;
import com.yyjz.icop.orgcenter.company.vo.bill.CompBillVO;
import com.yyjz.icop.orgcenter.company.vo.corporate.CorporateVO;
import com.yyjz.icop.orgcenter.company.vo.discipline.DisciplineVO;
import com.yyjz.icop.orgcenter.company.vo.procurement.ProcurementVO;
import com.yyjz.icop.orgcenter.opm.vo.OpmModelBo;
import com.yyjz.icop.orgcenter.opm.vo.OpmModelVo;
import com.yyjz.icop.util.ReferTreeData;

/**
 * @Author gaoyangk
 *
 * @Email gaoyangk@yonyou.com
 *
 * @Version 1.0
 * @CreateTime 2016年5月27日 上午9:47:38
 */
public interface ICompanyService {

	/**
	 * 获取当前租户下所有的行政组织  包含项目部类型组织
	 * @return 行政组织列表
	 */
	public List<CompanyVO> getAllCompany();
	/**
	 * 获取当前租户下所有的行政组织
	 * @param includeProject 是否包含项目部 true-包含 false-不包含
	 * @return 行政组织列表
	 */
	public List<CompanyVO> getAllCompany(boolean includeProject);
	/**
	 * 获取所有的行政组织，无租户隔离
	 * @param includeProject 是否包含项目部 true-包含 false-不包含
	 * @return 行政组织列表
	 */
	public List<CompanyVO> getAllCompanyIgnoreTenant(boolean includeProject);
	
	public List<CompanyVO> getAllCompanyById(String companyId);
	public List<CompanyVO> getAllCompanyById(String companyId, boolean includeProject);

	public CompanyVO getCompany(String id);
	public CompanyVO getCompanyById(String id);

	public List<CompanyVO> getCompanys(List<String> ids);

	public CompanyVO save(CompanyVO companyVO);
	
	/**
	 * 完整保存组织单元+职能信息
	 * @param companyJson 组织单元+职能信息
	 * @return 保存结果
	 */
	public JSONObject saveWhole(JSONObject companyJson);
	
	/**
	 * 移动组同步建总人力组织数据
	 * @param companyJson
	 * @return
	 */
	public JSONObject saveMobileSynch(JSONObject companyJson);

	public void saveBatch(List<CompanyVO> companyList);

	void del(String id);

	CompanyVO updateCompany(CompanyVO companyVO);

	public Boolean findCompanyByIdAndCode(CompanyVO companyVO);
	
	/**
	 * 判断编码是否重复
	 * @param companyId
	 * @param companyCode
	 * @return
	 */
	public Boolean hasRepeatCompanyCode(String companyId, String companyCode);
	
	public List<CompanyVO> getCompanysByCheckType(String checkBoxType);
	
	// 通过条件查询上本下分级组织
	public String getCompanysByCondition(String condition);

	/**
	 * 
	 * 方法功能描述：查询获取最大的仅下级节点的innercode的后四位，为新增时拼接innercode做准备 <b>参数说明</b>
	 * 
	 * @param id
	 * @return <p>
	 * @author yujian1
	 * @time 2016年4月25日 上午12:42:23
	 */
	public String getMaxInnercode(String id);

	/**
	 * 
	 * 方法功能描述：查询父级节点的innercode，为新增时拼接innercode做准备 <b>参数说明</b>
	 * 
	 * @param id
	 * @return <p>
	 * @author yujian1
	 * @time 2016年4月25日 上午12:43:05
	 */
	public String getInnercode(String id);

	/**
	 * 
	 * 方法功能描述：根据组织名称模糊查询 <b>参数说明</b>
	 * 
	 * @param name
	 * @return <p>
	 * @author yujian1
	 * @time 2016年5月31日 上午10:36:08
	 */
	public List<CompanyVO> getCompanysByName(String name);

	/**
	 * 
	 * 根据条件查询公司。
	 * <p>
	 * <b>examples:</b>
	 * <p>
	 * 使用示例
	 * <p>
	 * <b>参数说明</b>
	 * 
	 * @param searchParams
	 * @return <p>
	 * @author shl
	 * @time 2016年6月2日 下午4:52:58
	 */
	public List<CompanyVO> searchCompany(Map<String, Object> searchParams);

	/**
	 * 分页查询
	 * 
	 * @param searchParams
	 * @param pageRequest
	 * @return
	 */
	public Page<CompanyVO> searchCompany(Map<String, Object> searchParams, PageRequest pageRequest);

	/**
	 * 
	 * 方法功能描述：查询根节点 <b>参数说明</b>
	 * 
	 * @return <p>
	 * @author yujian1
	 * @time 2016年6月6日 下午7:22:46
	 */
	public CompanyVO queryRootCompany();

	/**
	 * 
	 * 方法功能描述：根据innercode查询下一级孩子 <b>参数说明</b>
	 * 
	 * @param innercode
	 * @return <p>
	 * @author yujian1
	 * @time 2016年6月6日 下午7:23:00
	 */
	public List<CompanyVO> queryChildCompany(String innercode);

	/**
	 * 
	 * 方法功能描述：查询其下面所有的孩子 <b>参数说明</b>
	 * 
	 * @param id
	 * @return <p>
	 * @author yujian1
	 * @time 2016年6月15日 下午3:11:47
	 */
	public List<CompanyVO> queryAllChildren(String id);

	/**
	 * 
	 * 方法功能描述：查询其下面所有的孩子 <b>参数说明</b>
	 * 
	 * @param id
	 * @return <p>
	 * @author yujian1
	 * @time 2016年6月15日 下午3:11:47
	 */
	public List<CompanyVO> queryAllChildren(String param,String id);

	/**
	 * 
	 * 方法功能描述：查询其上面所有的爹爹 <b>参数说明</b>
	 * 
	 * @param id
	 * @return <p>
	 * @author yujian1
	 * @time 2016年6月17日 上午10:06:05
	 */
	public List<String> queryAllParent(String id);

	/**
	 * 
	 * 方法功能描述：查询其所有的被停用的爹的数量 <b>参数说明</b>
	 * 
	 * @param orgFunId
	 * @param id
	 * @return <p>
	 * @author yujian1
	 * @time 2016年6月17日 下午4:30:56
	 */
	public int queryAllUnabledParent(String id);

	public List<CompanyVO> initTree(List<String> companyId, String code);

	void updateInnerCode(String newCode, String companyId);

	public List<String> treeStates(String code, int type);

	public String getCompanyIdByCode(String code);

	public String getMaxCodeLength();

	/**
	 * 
	 * 根据公司职能获取公司
	 * <p>
	 * <b>examples:</b>
	 * <p>
	 * 使用示例
	 * <p>
	 * <b>参数说明</b>
	 * 
	 * @param companyFuncId
	 * @return <p>
	 * @author shl
	 * @time 2016年8月15日 下午10:57:33
	 */
	public List<CompanyVO> getCompanyByFunc(String companyFuncId);

	/**
	 * 
	 * 根据职能获取公司数据
	 * <p>
	 * <b>examples:</b>
	 * <p>
	 * 使用示例
	 * <p>
	 * <b>参数说明</b>
	 * 
	 * @param searchText
	 * @param relyCondition
	 * @param pageRequest
	 * @return <p>
	 * @author shl
	 * @time 2016年8月15日 下午11:28:29
	 */
	public List<CompanyVO> refSearchComanyByFuns(String searchText, String relyCondition, PageRequest pageRequest);

	public List<CompanyVO> refSearchCompany(String searchText, String relyCondition, String companyId) throws BusinessException;

	/**
	 * 根据时间戳返回公司集合(移动组专用)
	 * 
	 * @param ts
	 *            时间戳
	 * @return
	 */
	public List<CompanyVO> getCompanyByTime(String ts, String start, String count, String tenantId);
	List<CompanyVO> getCompanyByTimeNew(String ts, String start, String count, String tenantId);

	public int getPageCount(String ts, String count);

	public List<CompanyVO> getInfoFromOrg(String orgId,String isComId);
	
	public List<CompanyVO> getInfoFromOrg(String orgId,String comId,String isComId);

	public List<CompanyVO> getChildrenCompanyById(String id);
	/**
	 * 根据组织单元id和职能code获取本下组织列表
	 * @param orgUnitId
	 * @param orgCode
	 * @return
	 */
	public List<CompanyVO> getChildrenCompanyById(String orgUnitId, String orgCode);
	
	public List<CompanyVO> getChildrenEnabledCompanyById(String id);

	/**
	 * 根据组织复制qi
	 * 
	 * @param companyId
	 * @return
	 */
	boolean copyMould(String companyId, String mouldId);

	/**
	 * 
	 * @param searchText
	 * @return
	 */
	public Page<CompanyVO> refSearchCompanyMould(String searchText, Pageable pageable);

	/**
	 *
	 * @param pageable
	 * @param innerCode
	 * @param searchText
	 * @return
	 */
	Page<CompanyVO> getChildren(Pageable pageable, String innerCode, String searchText);

	/**
	 * 组织部门树
	 * 
	 * @return
	 */
	List<ReferTreeData> getObjectCompanysAndDepts(String companyId,String selectable) throws BusinessException;

	/**
	 * 
	 * 方法功能描述：根据innercode返回其及父级树 <b>参数说明</b>
	 * 
	 * @param innercode
	 * @return <p>
	 * @author yujian1
	 * @time 2016年12月6日 下午6:23:15
	 */
	public List<CompanyVO> getParentsByInnerCode(String innercode);

	public Map<String, CompanyVO> getCorpMap(List<String> orgcodelist);

	/**
	 * 根据公司code查询
	 * 
	 * @param companyCode
	 * @return
	 */
	List<ReferTreeData> getObjectCompanysAndDeptsByCompanyCode(String companyCode) throws BusinessException;

	public CompanyVO getCompanyParentById(String id);

	public List<CompanyVO> getCompanysRelationOrgfuns(String orgFunName);

	List<CompanyVO> getCompanyAndFunctions();

	CompanyVO getCompanyAndFunctionsById(String companyId);

	public String getTypeOfId(String id);

	public List<CompanyVO> getAllCompanyBySearchText(String searchText,String companyId);
	public List<CompanyVO> getAllCompanyBySearchText(String searchText,String companyId, boolean includeProject);

	public List<String> getAllExentCompanyText(String searchText);

	public List<String> queryAllParentInnercode(String companyId);
	
	public CompanyVO findCompanyByCode(String companyCode);

	public List<CompanyVO> queryChildByCompanyId(String id);
	/**
	 * 查询所有虚拟组织
	 * 
	 * @return
	 */
	public List<CompanyVO> findCompanysByVirtual();

	/**
	 * 查询某虚拟分类下包含的组织
	 * 
	 * @return
	 */
	public List<CompanyVO> findCompanyChildByType(String companyId);

	/**
	 * 查询某组织所属的虚拟分类
	 * 
	 * @return
	 */
	public CompanyVO findCompanyVirtualParent(String companyId) ;

	/**
	 * 查询某组织的直接上下级组织和所有上下级组织
	 * 
	 * @param directOrAll
	 *            1:为直接 2：所有上下级
	 * @return
	 */
	public List<CompanyVO> findCompanyParentAndChild(String companyId, int directOrAll);
	
	/**
	 * 根据companyid查询纪检组织详情
	 * 
	 * @param companyId
	 *            
	 * @return DisciplineVO
	 */
	public DisciplineVO getDisciplineByCompanyId(String companyId);

	public List<CompanyVO> getCompanysRelationOrgfunsName(String funCodeName,String companyId);
	
	public Object getCompanysByfunNameAndcompanyId(String orgFunName,String companyId);

	public List<CompanyVO> queryNextChildren(String id);
	public List<CompanyVO> queryCompanyByPid(String pid);
	public List<CompanyVO> queryCompanyByPid(String pid, JSONObject condition);

		/**
		 * 根据父节点获取下属公司和部门参照（用于懒加载）
		 * @param pid 父节点ID
		 * @param isDept 是否是部门
		 * @return
		 */
	public List<ReferTreeData> queryCompanyAndDeptByPid(String pid,boolean isDept);

	public List<CompanyVO> queryAllParents(String id);
	
	public List<CompanyVO> queryNextChildrenNotVirtual(String id);

	public List<CompanyVO> queryAllParentsNotVirtual(String id);

	public List<String> queryAllIdChildren(String deptId, String tenantId);
	/**
	 * 批量插入基础组织
	 * 
	 * @param data
	 * @return
	 */
	public Map<String, String> batchAddCompany(Map<String, Object> data);
	/**
	 * 批量插入纪检
	 * 
	 * @param data
	 * @return
	 */
	public Map<String, String> batchAddDiscipline(Map<String, Object> dataMap);
	/**
	 * Excel导入基础组织--人力资源
	 * 
	 * @param data
	 * @return
	 */
	public Map<String, String> importHumanSource(Map<String, Object> data);

	public List<ReferTreeData> getObjectCompanysAndDeptsByCompanyCode(String companyCode, String selectable) throws BusinessException;

	public List<ReferTreeData> getObjectCompanysAndDeptsNew(String selectable)  throws BusinessException;

	public CompanyVO queryCurrUserMainJob(String userId);

	public List<CompanyVO> getAllCompanyList();
	
	public String UpOrDownCompany(String companyId,int orderNum);
	
	public CompanyVO getFatherCompanyById(String companyId);
	
	public List<String> getNearLegalPersonBetweenCompanyIds(String companyId);
	
	public CompanyVO getCompanyByUserId(String userId);

	/**
	 *  根据组织ID查询其及其下级所有的组织ID
	 **/
	public List<String> getAllCompanyIdsById(String companyId);
	
	public List<CompanyVO> getParentFromOrg(String orgId, String comId,String isComId);
	
	/**
	 * 筑云采专用，按照组织名称、code进行搜索
	 * @param searchText
	 * @param companyIdList 待查询的职能组
	 * @param pageNumber
	 * @param pageSize
	 * @return
	 */
	public Page<CompanyVO> refSearchBussCompany(String searchText,List<String> companyIdList,
			int  pageNumber, int pageSize);

	/**
	 * 保存法人、税务、采购职能接口，仅供筑云采使用
	 * @param corporate
	 * @param bill
	 * @param procurement
	 * @return
	 */
	public Map<String,Object> saveOrg(CorporateVO corporate,CompBillVO bill,ProcurementVO procurement);

	/**
	 * 为供应商创建组织，创建的组织挂在虚拟组织“供应商组织：SupplierOrg”下面
	 * @param supplierCode 分供方编码，对应组织编码，必要
	 * @param supplierName 分供方名称，对应公司名称，必要
	 * @param supplierShorName 分供方简称， 对应公司简称，必要
	 * @param supplierCreditCode  分供方社会信用统一代码，对应社会信用代码，非必要
	 * @param supplierId 分供方档案id,对应公司来源系统id
	 * @return 分供方组织vo
	 */
	public CompanyVO createSupplierCompany(
			String supplierCode, 
			String supplierName, 
			String supplierShorName,
			String supplierCreditCode,
			String supplierId);
	public CompanyVO createRootCompany(
			String companyName,
			String pid,
			String tenantId);
	/**
	 * 获取当前租户下最大的组织排序序号
	 * @return
	 */
	public Integer getMaxOrderNum();

	public CompanyVO getCompanyBySourceId(String sourceId);

	void delCompanyFun(String code, String companyId);
	
	public Page<CorporateVO> queryCorporateByQql(String sql,int pageNumber,int pageSize);

	public Map<String, String> batchAddCompanys(Map<String, Object> dataMap);
	
	public int newInnerCode(String companyCode);

	int deleteAllIsNull();
	
	/**
	 * 注册_根据tenantId获取根组织
	 */
	public CompanyVO queryRootCompanyByTenantId(String tenantId);
	
	/**
	 * 注册_新增组织时获取最大显示顺序
	 */
	public Integer getMaxOrderNumByTenantId(String tenantId);

	/**
	 * 注册_获取组织新的innercode
	 * @param rootCompanyId
	 * @param tenantId
	 * @return
	 */
	public String newCompanyInnerCodeByTenantId(String rootCompanyId, String tenantId);
	
	/**
	 * 
	 * 根据组织Innercode获取所有父节点组织（带组织隔离，取到二级组织）
	 */
	public List<CompanyVO> getParentsByInnerCodeForPubcloud(String innercode);

	/**
	 * 获得系统下所有顶级公司
	 * @return
	 */	List<CompanyVO> queryTopCompanies();

	/**
	 * 获得指定组织的直接下级
	 * @param companyId
	 * @return
	 */
	List<CompanyVO> getSubCompanies(String companyId);
	/**
	 * 获取指定组织直接下级（根据组织启停用状态）
	 * @param companyId 父节点组织主键
	 * @param status 组织起停用状态
	 * @return
	 */
	List<CompanyVO> getSubCompanies(String companyId, List<Integer> status);
	
	boolean saveOpm(String companyId,String companyName,OpmModelBo opmModelBo);
	OpmModelVo getOpm(String companyId);
	int newInnerCodeByCompanyId(String companyId);

	/**
	 * 根据组织单元ID获取本上级行政职能组织（只满足行政组织）
	 * @param companyId
	 * @param tenantId
	 * @return
	 */
	public List<CompanyVO> queryAllParents(String companyId, String tenantId);
	
	/**
	 * 根据组织单元ID和职能Code查询职能本上
	 * @param orgUnitId 组织单元ID
	 * @param tenantId 租户ID
	 * @param orgCode 职能code
	 * @return
	 */
	public List<CompanyVO> queryAllParents(String orgUnitId, String tenantId, String orgCode);

	/**
	 * 根据组织编码或者组织名称模糊查询所有的组织的id
	 * @param searchText
	 * @return
	 */
	public List<String> queryAllCompanyIdsBySearchText(String searchText);
	
	public List<CompanyVO> queryAllChildren(String param, String companyId, String tenantId);

	/**
	 * 查询公司
	 * 
	 * @param searchText
	 * @param innercode
	 * @param tenantId
	 * @return
	 */
	public List<CompanyVO> searchCompanys(String searchText, String innercode, String tenantId);
	
	/**
	 * 搜索符合条件的组织单元列表（本下）
	 * @param searchText 搜索关键字  关键字为空，则结果返回空列表
	 * @param orgUnitId 组织单元ID
	 * @param orgCode 职能编码({@link =})
	 * @param tenantId 租户ID
	 * @return 组织单元列表list<{@link = CompanyVO}>
	 */
	public List<CompanyVO> searchOrgUnits(String searchText, String orgUnitId, String orgCode, String tenantId) throws BusinessException;
	/**
	 * 修复id=pid组织的所有下级组织的innercode
	 * @param pid 需要修复组织的组织
	 * @param innercode 初始innercode
	 */
	void repairInnerCode(String pid, String innercode);

	/**
	 * 根据登录用户ID：userId 查询本上级组织
	 * @param userId
	 * 				登录用户ID
	 * @return
	 */
	Map<String, List<String>> queryCompanyMapByUserId(String userId);

	List<CompanyVO> getChildrenByType(String parentid,String type);// type:1 基础组织   2：党组织

	/**
	 * 校验上级组织是否可用
	 * @param id
	 * @param pid
	 * @return
	 */
	public boolean companyVerifyParent(String id, String pid);
	
	/**
	 * 同步NC组织数据
	 * 
	 * @param companyList
	 * @return
	 */
	public MapResponse<String, String> syncCompanyList(List<CompanyVO> companyList);
	
	/**
	 * 根据名称和简称模糊搜索组织
	 * @param companyName 组织名称
	 * @param ids 给定的查询范围，如果ids为null，则按照当前tenantId进行全表搜索
	 * @return 匹配到的组织id列表
	 */
	public List<String> searchCompanysByName(String companyName, List<String> ids);
	
	/**
	 * 根据名称或简称模糊搜索组织
	 * @param rootId 待查询的最高层组织
	 * @param companyName 组织名称
	 * @param page
	 * @param sort
	 * @return
	 */
	List<ReferTreeData> searchCompanysByName(String rootId, String companyName, List<Integer> companyTypes, PageRequest page, Sort sort, String tenantId);

	/**
	 * 根据名称严格（等值）筛选同名组织
	 * @param companyName
	 * @return
	 */
	List<CompanyVO> getStrictCompanysByName(String companyName);
	
	/**
	 * 根据系统id(systemId)查询系统的跟组织
	 */
	CompanyVO getRootCompany(String systemId);
}
