package com.yyjz.icop.orgcenter.company.service;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.orgcenter.company.vo.CompanyAndDeptTemplateVO;
import com.yyjz.icop.orgcenter.company.vo.CompanyTemplateVO;

public interface ICompanyTemplateService {
	/**
	 * 创建模板
	 * @param companyTemplateVO
	 * @return
	 * @throws BusinessException
     */
	boolean addMould(CompanyTemplateVO companyTemplateVO) throws BusinessException;

	/**
	 * 查看模板
	 * @param mouoldId
	 * @return
     */
	CompanyAndDeptTemplateVO getCompanyAndDeptTemplate(String mouoldId);

	/**
	 * 模板参照
	 * @param pageable
	 * @param innercode
	 * @param searchText
     * @return
     */
	Page<CompanyTemplateVO> getMouldChildren(Pageable pageable,List<String> companyIdList, String innercode, String searchText);

	/**
	 * 分页查询
	 * @param pageable
	 * @param searchText
     * @return
     */
	Page<CompanyTemplateVO> findPage(Pageable pageable, String searchText);

	/**
	 * 根据id批量删除模板
	 * @param ids
	 * @return
	 * @throws BusinessException
     */
	boolean deleteMould(List<String> ids) throws BusinessException;

	CompanyTemplateVO getcompanyTemplateOne(String mouldId);;
}
