package com.yyjz.icop.orgcenter.company.service.base;

import java.util.List;

import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.orgcenter.company.vo.orgunit.OrgUnitVO;

/**
 * 基本维护接口服务定义
 *
 * @param <OV> 继承自 {@code AbsIdEntity} 的实体
 * @author GavinWood
 * @date 2018年7月25日 上午10:33:21
 * @JDK jdk1.8
 */
public interface BaseService<OV extends OrgUnitVO>{
	/**
	 * 基本保存服务
	 *
	 * @param v 实体信息
	 * @param tenantId 租户标识（下同）
	 * @return 实体信息
	 * @throws BusinessException
	 */
	OV save(OV ov, String tenantId) throws BusinessException;

	/**
	 * 批量新增服务
	 *
	 * @param vos
	 * @return
	 * @throws BusinessException
	 */
	List<OV> save(List<OV> ovs, String tenantId) throws BusinessException;

	/**
	 * 基本更新服务
	 *
	 * @param v 实体信息
	 * @return 实体信息
	 * @throws BusinessException
	 */
	OV update(OV ov, String tenantId) throws BusinessException;

	/**
	 * 基本批量更新服务
	 *
	 * @param vos 实体信息
	 * @return 实体信息列表
	 * @throws BusinessException
	 */
	List<OV> update(List<OV> ovs, String tenantId) throws BusinessException;

	/**
	 * 基本启用服务
	 *
	 * @param v 实体信息
	 * @return 启用成功标志，{@code true} 启用成功，{@code false} 启用失败
	 * @throws BusinessException
	 */
	boolean enable(OV ov, String tenantId) throws BusinessException;

	/**
	 * 基本批量启用服务
	 *
	 * @param vos 实体信息列表
	 * @return 启用成功标志，{@code true} 启用成功，{@code false} 启用失败
	 * @throws BusinessException
	 */
	boolean enable(List<OV> ovs, String tenantId) throws BusinessException;

	/**
	 * 基本批量启用服务,无校验
	 *
	 * @param vos
	 * @return
	 * @throws BusinessException
	 */
	boolean enableWithNoCheck(List<OV> ovs, String tenantId) throws BusinessException;

	/**
	 * 基本停用服务
	 *
	 * @param v 实体信息
	 * @return 停用成功标志，{@code true} 停用成功，{@code false} 停用失败
	 * @throws BusinessException
	 */
	boolean disable(OV ov, String tenantId) throws BusinessException;

	/**
	 * 基本批量停用服务
	 *
	 * @param vos 实体信息列表
	 * @return 停用成功标志，{@code true} 停用成功，{@code false} 停用失败
	 * @throws BusinessException
	 */
	boolean disable(List<OV> ovs, String tenantId) throws BusinessException;
	
	/**
	 * 基本移动服务
	 *
	 * @param source 起始实体
	 * @param target 目标实体
	 * @return 移动结果，{@code true} 移动成功，{@code false} 移动失败
	 * @throws BusinessException
	 */
	boolean move(OV source, OV target, String tenantId) throws BusinessException;

	/**
	 * 基本删除服务
	 *
	 * @param v 实体信息
	 * @return 删除是否成功标志，{@code true} 删除成功，{@code false} 删除失败
	 * @throws BusinessException
	 */
	OV remove(OV ov, String tenantId) throws BusinessException;

	/**
	 * 基本批量删除服务
	 *
	 * @param vos 实体集合
	 * @return 删除是否成功标志，全部成功，或全部失败，{@code true} 删除成功，{@code false} 删除失败
	 * @throws BusinessException
	 */
	List<OV> removeBatch(List<OV> ovs, String tenantId) throws BusinessException;
}
