package com.yyjz.icop.orgcenter.company.service.base;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.orgcenter.company.vo.orgunit.OrgUnitVO;

/**
 * 组织版本查询、编辑接口
 *
 * @author GavinWood
 * @date 2018年7月25日 上午10:33:21
 * @JDK jdk1.8
 */
public interface BaseVService {

    /**
     * 根据主键信息查询实体
     *
     * @param orgUnitId  组织单元ID
     * @return List
     * @throws BusinessException
     */
	List listByOrgUnitId(String orgUnitId, String orgType) throws BusinessException;

    /**
     * 根据版本id查询版本详情
     *
     * @param id 版本主键
     * @param dr
     * @return OrgUnitVO
     * @throws BusinessException
     */
	OrgUnitVO getByVid(String id, String orgType) throws BusinessException;
    
    /**
     * 根据版本id查询版本详情
     *
     * @param vcode 版本编码
     * @param dr
     * @return JSONObject
     * @throws BusinessException
     */
    JSONObject getByVCode(String vcode) throws BusinessException;

    /**
	 * 基本保存服务
	 *
	 * @param json 传入参数
	 * @return JSONObject
	 * @throws BusinessException
	 */
	JSONObject save(JSONObject json) throws BusinessException;
}
