package com.yyjz.icop.orgcenter.company.vo;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

import com.yyjz.icop.base.vo.SuperVO;
import com.yyjz.icop.base.vo.tree.SuperTreeVO;

/**
 * @Author gaoyangk
 *
 * @Email gaoyangk@yonyou.com
 *
 * @Version 1.0
 * @CreateTime 2016年5月27日 上午9:16:31
 */
public class CompanyVO extends SuperTreeVO {

	private static final long serialVersionUID = 4572837329279881431L;

	/**
	 * 顶级公司编码
	 */
	public static final String TOP_COMPANY_CODE = "0001";

	// 来源于前端portal模块CodeRuleConstants.js文件
	public static final String CODERULES_ORG_MANAGE_RULE_ID = "12";

	/**
	 * 法人code
	 */
	public static final String TAB_CORPORATE = "0001";

	/**
	 * 人力资源code
	 */
	public static final String TAB_HR = "0002";

	/**
	 * 投资code
	 */
	public static final String TAB_INVESTMENT = "0003";

	/**
	 * 财务code
	 */
	public static final String TAB_FINANCE = "0004";

	/**
	 * 采购code
	 */
	public static final String TAB_PROCUREMENT = "0005";

	/**
	 * 税务code
	 */
	public static final String TAB_COMPBILL = "0006";

	protected String companyCode;

	protected String companyName;

	protected String companyShName;

	protected String companyType;

	protected int enabled;

	private String pid;

	protected String pname;

	protected String vid;

	protected String vname;

	protected String vno;

	protected String vstartDate;

	protected String vendDate;

	private String orgFunId;

	private String mouldId;

	private String mouldName;

	private Integer mould;
	/**
	 * 社会信用代码
	 */
	private String creditCode;

	private String tenantId;
	private String systemId;

	private String sourceId;

	private Integer orderNum; // 排序序号

	private Boolean isLeaf;

	private boolean hasChildren;

	private Timestamp enabledTime;

	private String attachmentId;

	private Integer isPrev = 0;

	private String orgType; // 职能类型
	
	public String getAttachmentId() {
		return attachmentId;
	}

	public void setAttachmentId(String attachmentId) {
		this.attachmentId = attachmentId;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public String getCreditCode() {
		return creditCode;
	}

	public void setCreditCode(String creditCode) {
		this.creditCode = creditCode;
	}

	private Map<String, SuperVO> functions;

	public String getOrgFunId() {
		return orgFunId;
	}

	public void setOrgFunId(String orgFunId) {
		this.orgFunId = orgFunId;
	}

	public String getCompanyCode() {
		return companyCode;
	}

	public void setCompanyCode(String companyCode) {
		this.companyCode = companyCode;
	}

	public String getCompanyName() {
		return companyName;
	}

	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public String getCompanyShName() {
		return companyShName;
	}

	public void setCompanyShName(String companyShName) {
		this.companyShName = companyShName;
	}

	public String getCompanyType() {
		return companyType;
	}

	public void setCompanyType(String companyType) {
		this.companyType = companyType;
	}

	public int getEnabled() {
		return enabled;
	}

	public void setEnabled(int enabled) {
		this.enabled = enabled;
	}

	public String getPname() {
		return pname;
	}

	public void setPname(String pname) {
		this.pname = pname;
	}

	public String getVid() {
		return vid;
	}

	public void setVid(String vid) {
		this.vid = vid;
	}

	public String getVname() {
		return vname;
	}

	public void setVname(String vname) {
		this.vname = vname;
	}

	public String getVno() {
		return vno;
	}

	public void setVno(String vno) {
		this.vno = vno;
	}

	public String getVstartDate() {
		return vstartDate;
	}

	public void setVstartDate(String vstartDate) {
		this.vstartDate = vstartDate;
	}

	public String getVendDate() {
		return vendDate;
	}

	public void setVendDate(String vendDate) {
		this.vendDate = vendDate;
	}

	public String getPid() {
		return pid;
	}

	public void setPid(String pid) {
		this.pid = pid;
	}

	public String getMouldId() {
		return mouldId;
	}

	public void setMouldId(String mouldId) {
		this.mouldId = mouldId;
	}

	public Integer getMould() {
		return mould;
	}

	public void setMould(Integer mould) {
		this.mould = mould;
	}

	public String getMouldName() {
		return mouldName;
	}

	public void setMouldName(String mouldName) {
		this.mouldName = mouldName;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	/**
	 * 
	 * 父类方法重写：先序遍历，拼接JSON字符串
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		String result = "{" + "\"key\": \"" + id + "\"" + ", \"companyCode\" : \"" + companyCode + "\""
				+ ", \"companyName\" : \"" + companyName + "\"" + ", \"companyShName\" : \"" + companyShName + "\""
				+ ", \"companyType\" : \"" + companyType + "\", \"enabled\" : \"" + enabled + "\", \"innercode\" : \""
				+ innercode + "\"" + ", \"vid\" : \"" + vid + "\"" + ", \"vname\" : \"" + vname + "\""
				+ ", \"creationtime\" : \"" + getCreationTimestamp() + "\"" + ", \"vno\" : \"" + vno + "\""
				+ ", \"lastmodifiedtime\" : \"" + getModificationTimestamp() + "\"" + ", \"dr\" : \"" + dr
				+ "\", \"pname\" : \"" + pname + "\",\"vstartDate\":" + "\"" + vstartDate + "\",\"vendDate\":" + "\""
				+ vendDate + "\",\"pid\":" + "\"" + pid + "\"";
		if (getChildren().size() != 0) {
			result += ", \"children\" : [";
			for (int i = 0; i < getChildren().size(); i++) {
				result += ((CompanyVO) getChildren().get(i)).toString() + ",";
			}
			result = result.substring(0, result.length() - 1);
			result += "]";
		}
		return result + "}";
	}

	public Map<String, SuperVO> getFunctions() {
		return functions;
	}

	public void setFunctions(Map<String, SuperVO> functions) {
		this.functions = functions;
	}

	public SuperVO putFunction(String key, SuperVO value) {
		if (null == this.functions) {
			this.functions = new HashMap<>();
		}
		return this.functions.put(key, value);
	}

	public Integer getOrderNum() {
		return orderNum;
	}

	public void setOrderNum(Integer orderNum) {
		this.orderNum = orderNum;
	}

	public Boolean getIsLeaf() {
		return isLeaf;
	}

	public void setIsLeaf(Boolean isLeaf) {
		this.isLeaf = isLeaf;
	}

	public boolean getHasChildren() {
		return hasChildren;
	}

	public void setHasChildren(boolean hasChildren) {
		this.hasChildren = hasChildren;
	}

	public Timestamp getEnabledTime() {
		return enabledTime;
	}

	public void setEnabledTime(Timestamp enabledTime) {
		this.enabledTime = enabledTime;
	}

	public Integer getIsPrev() {
		return isPrev == null ? 0 : isPrev;
	}

	public void setIsPrev(Integer isPrev) {
		this.isPrev = isPrev == null ? 0 : isPrev;
	}

	public String getOrgType() {
		return orgType;
	}

	public void setOrgType(String orgType) {
		this.orgType = orgType;
	}
	
	public String getInnerCode() {
		return innercode;
	}

	public void setInnerCode(String innercode) {
		this.innercode = innercode;
	}
}
