package com.yyjz.icop.orgcenter.company.vo.orgunit;

import java.io.Serializable;
import java.util.List;

import com.yyjz.icop.base.vo.SuperVO;
import com.yyjz.icop.database.entity.BeanHelper;
import com.yyjz.icop.orgcenter.company.vo.CompanyVO;

/**
 * 组织单元VO
 * @author GavinWood
 */
public abstract class OrgUnitVO<V extends SuperVO> implements Serializable {
	private static final long serialVersionUID = 4572837329279881431L;

	private CompanyVO orgUnit;
	
	private V org;
	
	private List<OrgUnitVO<SuperVO>> orgs;
	
	private boolean loaded = false;// 职能组织生成方式 新增 false 引入 true

	public boolean isLoaded(){
		return loaded;
	}

	public void setLoaded(boolean loaded){
		this.loaded = loaded;
	}

	public CompanyVO getOrgUnit(){
		return orgUnit;
	}

	public void setOrgUnit(CompanyVO orgUnit){
		this.orgUnit = orgUnit;
	}
	
	public V getOrg(){
		return org;
	}

	public void setOrg(V org){
		this.org = org;
	}

	public List<OrgUnitVO<SuperVO>> getOrgs(){
		return orgs;
	}

	public void setOrgs(List<OrgUnitVO<SuperVO>> orgs){
		this.orgs = orgs;
	}
	
	// OrgUnit
//	public String getOrgUnitCode(){
//		return orgUnit.getCompanyCode();
//	}
//	
//	public void setOrgUnitCode(String orgUnitCode){
//		orgUnit.setCompanyCode(orgUnitCode);
//	}
//	
//	public String getOrgUnitName(){
//		return orgUnit.getCompanyName();
//	}
//	
//	public void setOrgUnitName(String orgUnitName){
//		orgUnit.setCompanyName(orgUnitName);
//	}
//	
//	public String getOrgUnitShName(){
//		return orgUnit.getCompanyShName();
//	}
//	
//	public void setOrgUnitShName(String orgUnitShName){
//		orgUnit.setCompanyShName(orgUnitShName);
//	}
	
	// org 
	public String getOrgUnitId(){
		return (String)this.getAttributeValue("companyId");
	}
	
	public void setOrgUnitId(String orgUnitId){
		this.setAttributeValue("companyId", orgUnitId);
	}
	
	public String getParentId(){
		return (String)this.getAttributeValue("parentId");
	}
	
	public void setParentId(String parentId){
		this.setAttributeValue("parentId", parentId);
	}
	
	public String getParentName(){
		return (String)this.getAttributeValue("parentName");
	}
	
	public void setParentName(String parentName){
		this.setAttributeValue("parentName", parentName);
	}
	
	public String getOwerOrgId(){
		try{
			return (String)this.getAttributeValue("owerOrgId");
		}catch(Exception e){
			return null;
		}
	}
	
	public void setOwerOrgId(String owerOrgId){
		try{
			this.setAttributeValue("owerOrgId", owerOrgId);
		}catch(Exception e){
		}
	}
	
	public String getOwerOrgName(){
		try{
			return (String)this.getAttributeValue("owerOrgName");
		}catch(Exception e){
			return null;
		}
	}
	
	public void setOwerOrgName(String owerOrgName){
		try{
			this.setAttributeValue("owerOrgName", owerOrgName);
		}catch(Exception e){
		}
	}
	
	private int enabled = 0;// 默认启动
	
	public int getEnabled(){
		return enabled;
	}

	public void setEnabled(int enabled){
		this.enabled = enabled;
	}

	private Object getAttributeValue(String name){
		return BeanHelper.getProperty(org, name);
	}

	private void setAttributeValue(String name, Object value){
		BeanHelper.setProperty(org, name, value);
	}
	
	@Override
	public String toString(){
		String result = "{\"id\" : \"" + orgUnit.getId() + "\", " + "\"orgUnitCode\" : \"" + orgUnit.getCompanyCode() + "\", " 
					+ "\"orgUnitName\" : \"" + orgUnit.getCompanyName() + "\", " + "\"orgUnitShName\" : \"" + orgUnit.getCompanyShName() + "\", " 
					+ "\"creationtime\" : \"" + orgUnit.getCreationTimestamp() + "\", " 
					+ "\"lastmodifiedtime\" : \"" + orgUnit.getModificationTimestamp() + "\", "
					+ "\"dr\":\"" + orgUnit.getDr() + "\"}";
		return result;
	}
}
