package com.yyjz.icop.orgcenter.dept.service;

import java.util.List;
import java.util.Map;

import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.base.response.MapResponse;
import com.yyjz.icop.orgcenter.dept.vo.CompanyDeptPositionTreeVO;
import com.yyjz.icop.orgcenter.dept.vo.DeptVO;
import com.yyjz.icop.util.ReferTreeData;

/**
 * Created by zsk on 2016/5/31.
 */

public interface IDeptService {
    /**
     *
     * @return
     */
    public List<DeptVO> getAllDept(String companyId);
    /**
	 * <p>根据公司获取其部门</p>
	 * @param companyId 公司ID
	 * @param enabled 是否启用 0：启用 1：停用 其他：全部
	 * @return java.util.List<com.yyjz.icop.orgcenter.dept.vo.DeptVO>
	 * @author zhangxn
	 * @date 2018/3/26 14:48
	 */
    public List<DeptVO> getAllDept(String companyId,int enabled);

    public DeptVO getDept(String id);
    
    public List<DeptVO> getDepts(List<String> ids);

    public void save(DeptVO deptVO);
    
    public void saveBatch(List<DeptVO> companyList);

    void del(String id, String companyId);

    DeptVO updateDept(DeptVO deptVO);

    /**
     *
     * 方法功能描述：查询获取最大的仅下级节点的innercode的后四位，为新增时拼接innercode做准备
     * <b>参数说明</b>
     * @param id
     * @return
     * <p>
     * @author yujian1
     * @time 2016年4月25日 上午12:42:23
     */
    public String getMaxInnercode(String id);
    /**
     *
     * 方法功能描述：查询父级节点的innercode，为新增时拼接innercode做准备
     * <b>参数说明</b>
     * @param id
     * @return
     * <p>
     * @author yujian1
     * @time 2016年4月25日 上午12:43:05
     */
    public String getInnercode(String id);

    String getMaxDeptByCompId(String companyId);
    
    /**
     * 
     * 方法功能描述：根据公司id查询公司下的根部门
     * <b>参数说明</b>
     * @param companyId
     * @return
     * <p>
     * @author yujian1
     * @time 2016年6月12日 下午4:24:11
     */
    public List<DeptVO> getRootDeptByComId(String companyId);
    public List<DeptVO> getRootDeptByComIdNew(String companyId);

    /**
     * 
     * 方法功能描述：根据公司id和innercode查询下一级孩子部门
     * <b>参数说明</b>
     * @param companyId
     * @param innercode
     * @return
     * <p>
     * @author yujian1
     * @time 2016年6月12日 下午4:39:16
     */
	public List<DeptVO> queryChildDept(String companyId,String innercode);
    /**
     *
     * 方法功能描述：根据公司id和innercode查询下一级孩子部门
     * <b>参数说明</b>
     * @param companyId
     * @param innercode
     * @return
     * <p>
     * @author yujian1
     * @time 2016年6月12日 下午4:39:16
     */
	public List<DeptVO> queryChildDeptNew(String companyId,String innercode);

	/**
	 * 根据公司id获取部门id集合
	 * @param companyId
	 * @return
	 */
	public List<String> getAllDeptIds(String companyId);
	/**
	 * 
	 * 方法功能描述：根据公司和部门id查询此部门所有的爹爹
	 * <b>参数说明</b>
	 * @param companyId
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年6月17日 下午2:44:12
	 */
	public List<String> queryAllParent(String companyId,String id);
	
	/**
	 * 
	 * 方法功能描述：查询其所有的被停用的爹的数量
	 * <b>参数说明</b>
	 * @param orgFunId
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年6月17日 下午4:30:56
	 */
	public int queryAllUnabledParent(String companyId,String id);
	
	/**
	 * 
	 * 方法功能描述：查询所有孩子
	 * <b>参数说明</b>
	 * @param companyId
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年6月17日 下午5:04:19
	 */
	public List<DeptVO> queryAllChildren(String companyId,String id);
	
	/**
	 * 移动组专用 按照修改时间查询部门
	 */
	public List<DeptVO> getDeptByTime(String ts,String start,String count, String tenantId);
	/**
	 * 移动组专用 按照修改时间查询部门
	 */
	List<DeptVO> getDeptByTimeNew(String ts,String start,String count, String tenantId);
    // 根据vo中id和code值判断当前有部门数据
	public Boolean findDeptByIdAndCode(DeptVO vo);
    // 根据vo中id和name和companyId值判断当前有部门数据
	public Boolean findDeptByIdAndName(DeptVO vo);

	public int getPageCount(String ts, String count);

	/**
	 * 通过组织id查询组织、部门、岗位单根树
	 * @param companyId
	 * @return
     */
	CompanyDeptPositionTreeVO getDeptAndPositionTree(String companyId) throws BusinessException;

	void delAllDeptByCompanyId(String id);
	
	public List<ReferTreeData> getDeptRef(String companyId);
	List<ReferTreeData> getDeptRef(String companyId,int enabled);

	public List<DeptVO> getPostionsByIds(List<String> ids);

	public List<DeptVO> getDeptsByComIdAndName(String companyId, String deptName);
	public List<DeptVO> getDeptsByComIdAndName(String companyId, String deptName,int enabled);

	public List<String> queryAllIdChildren(String companyId, String deptId,
			String tenantId);

	public Map<String, String> importDept(Map<String, Object> dataMap);

	/**
	 * 根据用户Id查询出用户对应所有人员所对应的部门包含正在兼职的部门
	 * 
	 * @param userId
	 * @return List<DeptVO> 对应的部门列表
	 */
	public List<DeptVO> getAllDeptsByUserId(String userId);

    Integer getMaxDeptOrderByPid(String pid);

	Integer getDeptOrder(String id);

    String editDeptOrder(String id, Integer deptOrder);

	Integer getMaxDeptOrderByCompanyId(String companyId);

	/*
	* 根据组织ID获取其及其下级组织的所有的部门id
	* */
	List<String> getAllDeptIdsByCompanyId(String companyId);
	
	/**
	 * 在指定组织下创建供应商的顶级部门，命名为“综合管理部”
	 * @param companyId 所属公司Id
	 * @param companyName 所属公司名称
	 * @return
	 */
	DeptVO createSupplierDept(String companyId, String companyName);

	public int newInnerCode(String deptCode,String companyCode);

	public Map<String, String> importDepts(Map<String, Object> data);

	int deleteAllIsNull();
	
	/**
	 * 
	 * 方法功能描述：根据公司和部门id查询此部门所有的爹爹实体
	 */
	public List<DeptVO> queryAllParentDeptVO(String companyId,String id);

	public List<DeptVO> getNextByCompanyIdAndPid(String pid,String companyId);

	/**
	 * 保存部门并返回保存后的VO
	 */
	public DeptVO saveAndRet(DeptVO deptVO);
	
	/**
	 * 查询部门是否有下级部门
	 * @param companyId
	 * @param deptId
	 * @return
	 */
	public boolean hasChild(String companyId, String deptId);
	
	/**
	 * 根据sourceId获取部门
	 */
	public DeptVO getDeptBySourceId(String sourceId);
	
	/**
	 * 根据companyId以及部门名称完全匹配获取部门
	 */
	public List<DeptVO> getDeptsByComIdAndDeptname(String companyId,String deptName);
	
	/**
	 * 同步NC部门数据
	 * 
	 * @param deptList
	 * @return
	 */
	public MapResponse<String, String> syncDeptList(List<DeptVO> deptList);
}