package com.yyjz.icop.orgcenter.opm.vo;

import com.yyjz.icop.base.vo.SuperVO;
import com.yyjz.icop.base.vo.tree.MultipleNoSortTree;

import java.util.List;

public class OpmModelVo extends SuperVO {
		private static final long serialVersionUID = -4251535744749727213L;
		private String code;// 模板编码
		private String name;// 模板名称
		private Integer scope;// 应用范围：1是组织 0是本组织以及以下组织
		private Integer refType;// 引用类型（1：模板 2：项目部 3：原生）
		private String refId;// 引用模板或项目部ID
		private String companyId;// 模板所属公司
		private String tenantId;// 租户ID
		private String description;// 模板说明
		private List<DeptModelVo> deptModels;//所有部门
		public String getCode() {
				return code;
		}

		public void setCode(String code) {
				this.code = code;
		}

		public String getName() {
				return name;
		}

		public void setName(String name) {
				this.name = name;
		}

		public Integer getScope() {
				return scope;
		}

		public void setScope(Integer scope) {
				this.scope = scope;
		}

		public Integer getRefType() {
				return refType;
		}

		public void setRefType(Integer refType) {
				this.refType = refType;
		}

		public String getRefId() {
				return refId;
		}

		public void setRefId(String refId) {
				this.refId = refId;
		}

		public String getCompanyId() {
				return companyId;
		}

		public void setCompanyId(String companyId) {
				this.companyId = companyId;
		}

		public String getTenantId() {
				return tenantId;
		}

		public void setTenantId(String tenantId) {
				this.tenantId = tenantId;
		}

		public String getDescription() {
				return description;
		}

		public void setDescription(String description) {
				this.description = description;
		}

		public List<DeptModelVo> getDeptModels() {
				return deptModels;
		}

		public void setDeptModels(List<DeptModelVo> deptModels) {
				this.deptModels = deptModels;
		}

		@Override
		public String toString() {
				return "{" +
								"\"code\":\"" + code + "\"" +
								", \"name\":\"" + name + "\"" +
								", \"scope\":" + scope +
								", \"refType\":" + refType +
								", \"refId\":\"" + refId + "\"" +
								", \"companyId\":\"" + companyId + "\"" +
								", \"tenantId\":\"" + tenantId + "\"" +
								", \"description\":\"" + description + "\"" +
								", \"id\":\"" + id + "\"" +
								", \"creationTimestamp\":\"" + creationTimestamp + "\"" +
								", \"modificationTimestamp\":\"" + modificationTimestamp + "\"" +
								", \"dr\":" + dr +
								", \"deptModels\":" + MultipleNoSortTree.getTree(deptModels) +
								"}";
		}
}
