package com.yyjz.icop.orgcenter.opm.vo;

import com.yyjz.icop.base.entity.AbsIdEntity;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;

public class PositionUnionModelVo extends AbsIdEntity implements RowMapper<PositionUnionModelVo> {
		private static final long serialVersionUID = 2590166563927557686L;
		private String deptId;//所属部门ID
		private String positionId;//岗位ID
		private String positionName;//岗位name
		private String positionCode;//岗位code
		private String positionDsc;//岗位描述
		private Integer positionType;//岗位序列
		private String levelId;// 岗位分类
		private String levelName;// 岗位分类名称
		private String rowState;

		public String getPositionId() {
				return positionId;
		}

		public void setPositionId(String positionId) {
				this.positionId = positionId;
		}

		public String getPositionName() {
				return positionName;
		}

		public void setPositionName(String positionName) {
				this.positionName = positionName;
		}

		public String getPositionCode() {
				return positionCode;
		}

		public void setPositionCode(String positionCode) {
				this.positionCode = positionCode;
		}

		public String getPositionDsc() {
				return positionDsc;
		}

		public void setPositionDsc(String positionDsc) {
				this.positionDsc = positionDsc;
		}

		public Integer getPositionType() {
				return positionType;
		}

		public void setPositionType(Integer positionType) {
				this.positionType = positionType;
		}

		public String getLevelId() {
				return levelId;
		}

		public void setLevelId(String levelId) {
				this.levelId = levelId;
		}

		public String getLevelName() {
				return levelName;
		}

		public String getDeptId() {
				return deptId;
		}

		public void setDeptId(String deptId) {
				this.deptId = deptId;
		}

		public void setLevelName(String levelName) {
				this.levelName = levelName;
		}

		public String getRowState() {
				return rowState;
		}

		public void setRowState(String rowState) {
				this.rowState = rowState;
		}

		private boolean isExistColumn(ResultSet rs, String columnName) {
				try {
						if (rs.findColumn(columnName) > 0) {
								return true;
						}
				} catch (SQLException e) {
						return false;
				}
				return false;
		}
		@Override
		public PositionUnionModelVo mapRow(ResultSet rs, int i) throws SQLException {
				PositionUnionModelVo vo=new PositionUnionModelVo();
				if (isExistColumn(rs, "dept_id"))
						vo.setDeptId(rs.getString("dept_id"));
				if (isExistColumn(rs, "position_id"))
						vo.setPositionId(rs.getString("position_id"));
				if (isExistColumn(rs, "position_name"))
						vo.setPositionName(rs.getString("position_name"));
				if (isExistColumn(rs, "position_code"))
						vo.setPositionCode(rs.getString("position_code"));
				if (isExistColumn(rs, "position_description"))
						vo.setPositionDsc(rs.getString("position_description"));
				if (isExistColumn(rs, "position_type"))
						vo.setPositionType(rs.getInt("position_type"));
				if (isExistColumn(rs, "level_id"))
						vo.setLevelId(rs.getString("level_id"));
				if (isExistColumn(rs, "level_name"))
						vo.setLevelName(rs.getString("level_name"));
				return vo;
		}

		@Override
		public String toString() {
				return "{" +
								"\"deptId\":\"" + deptId + "\"" +
								", \"positionId\":\"" + positionId +  "\"" +
								", \"positionName\":\"" + positionName +  "\"" +
								", \"positionCode\":\"" + positionCode +  "\"" +
								", \"positionDsc\":\"" + positionDsc +  "\"" +
								", \"positionType\":" + positionType +
								", \"levelId\":\"" + levelId +  "\"" +
								", \"levelName\":\"" + levelName +  "\"" +
								"}";
		}
}
