package com.yyjz.icop.orgcenter.orgFunDivision.service;

import java.util.List;

import com.yyjz.icop.orgcenter.orgFuns.vo.OrgFunsVo;
import com.yyjz.icop.orgcenter.staff.vo.StaffVO;

public interface IOrgFunDivisionServiceApi {

	
	public List<String> findAllUserIdByOrgFunIds(List<String> orgFunIds);

	public List<String> getAllUserIdByOrgFunIdsApi(List<String> orgFunIds);

	int countOrgFunUserRefByCompanyId(String companyId, String notInOrgFunId, List<String> inOrgFunIds,
			String searchText);

	List<StaffVO> orgFunRelaionUserRefByCompanyId(String companyId, String notInOrgFunId, List<String> inOrgFunIds,
			String searchText, int pageNum, int pageSize);
	
	/**
	 * 查询用户具有的职能分类
	 * 若查询为空时，则默认放入行政职能分类
	 * 
	 * @return
	 */
	public List<OrgFunsVo> getAllOrgFunsByUserId(String userId);
	
	/**
	 * 查询指定组织本下指定职能分类的用户数量（按用户去重）
	 * 
	 * @param companyId
	 * @param notInOrgFunId
	 * @param inOrgFunIds
	 * @param searchText
	 * @return
	 */
	public int countNoRepeatOrgFunUserRefByCompanyId(String companyId, String notInOrgFunId, List<String> inOrgFunIds,
			String searchText);
	
	/**
	 * 查询指定组织本下指定职能分类的用户信息（按用户去重）
	 * 
	 * @param companyId
	 * @param notInOrgFunId
	 * @param inOrgFunIds
	 * @param searchText
	 * @return
	 */
	public List<StaffVO> noRepeatOrgFunRelUserByCompanyId(String companyId, String notInOrgFunId,
			List<String> inOrgFunIds, String searchText, int pageNum, int pageSize);
}
