package com.yyjz.icop.orgcenter.orgFuns.service;

import java.util.List;
import java.util.Map;

import com.yyjz.icop.orgcenter.orgFuns.vo.OrgFunsVo;

/**
 *@Author
 *		gaoyangk
 *
 *@Email
 *		gaoyangk@yonyou.com
 *
 *@Version
 *		1.0
 *@CreateTime
 *		2016年5月24日  下午2:17:17
*/
public interface IOrgFunsService {
	
	/**
	 * 获取所有组织职能
	 * @return
	 */
	public List<OrgFunsVo> getAllOrgFuns();
	
	/**
	 * 根据Id删除，逻辑删除，把dr置为1
	 * @param id
	 */
	void delOrgFuns(String id);
	
	/**
	 * 保存
	 * @param vo
	 * @return
	 */
	public OrgFunsVo save(OrgFunsVo vo);
	/**
	 * 根据Id查询
	 * @param id
	 * @return
	 */
	public OrgFunsVo getOrgFuns(String id);
	
	public OrgFunsVo getOrgFunsByCode(String orgFunCode);
	/**
	 * 根据Id及code查询是否有值
	 * @param vo
	 * @return
	 */
	public Boolean findOrgFunsByIdAndCode(OrgFunsVo vo);

	/**
	 * 根据名字查询到对应的组织职能ID
	 * 
	 * @param funcNames
	 * @param tenantId
	 * @return
	 */
	public List<OrgFunsVo> findByNames(List<String> funcNames, String tenantId);

	public List<OrgFunsVo> findByIds(List<String> orgFunIds);

	public List<OrgFunsVo> findByProerties(List<String> orgFunIds, String searchText);

	public List<OrgFunsVo> queryAllByProperties(Map<String, Object> queryMap);
	
//	public CompanyVO getCompanyVOByOrgFuns(String orgFunId, String companyId);
	
}
