/**
 * $文件说明$
 *
 * @author Alex
 * @version 
 * @see
 * @since
 * @time 2016年6月4日 上午10:22:53
 */
package com.yyjz.icop.orgcenter.orgcenter.service;

import java.util.List;

import org.springframework.data.domain.PageRequest;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.orgcenter.company.service.ExtReferTreeData;
import com.yyjz.icop.orgcenter.company.vo.CompanyVO;
import com.yyjz.icop.orgcenter.company.vo.remarkcol.RemarkColVO;
import com.yyjz.icop.orgcenter.orgFuns.vo.OrgFunsVo;
import com.yyjz.icop.orgcenter.orgcenter.vo.OrgCenterTreeVo;
import com.yyjz.icop.orgcenter.orgcenter.vo.OrgCenterVO;

/**
 * <p>
 * 本类主要功能：组织中心接口
 * <p>
 * @version YYCC_V1.0
 * @author yujian1
 * @time 2016年6月4日 上午10:22:53
 */
public interface IOrgCenterService {
	
	/**
	 * 
	 * 方法功能描述：根据组织职能主键查询对应组织
	 * <b>参数说明</b>
	 * @param orgFunId
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年6月4日 上午10:27:05
	 */
	public List<OrgCenterVO> getOrgsByFunId(String orgFunId);
	
	public List<OrgCenterVO> getOrgs(String orgFunId,String id);
	
	public List<OrgCenterVO> getOrgByorgFunCode(String orgFunCode,String id);
	
	public List<OrgCenterVO> getOrgsByFunCode(String orgFunCode);
	/**
	 * 
	 * 方法功能描述：根据组织id删除组织
	 * <b>参数说明</b>
	 * @param id 
	 * <p>
	 * @author yujian1
	 * @time 2016年6月4日 上午11:18:27
	 */
	void delOrg(String id, String func_id);
	/**
	 * 
	 * 方法功能描述：根据组织id查询组织
	 * <b>参数说明</b>
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年6月4日 上午11:31:32
	 */
	public OrgCenterVO getOrgById(String id);
	/**
	 * 
	 * 方法功能描述：根据组织id和职能code查询该组织或上级组织
	 * <b>参数说明</b>
	 * @param id
	 * @return
	 * <p>
	 * @author tangtaod
	 * @time 2016年6月4日 上午11:31:32
	 */
	public OrgCenterVO getOrgByIdAndFunCode(String id,String funCode);
	
	
	
	
	/**
	 * 
	 * 方法功能描述：保存
	 * <b>参数说明</b>
	 * @param orgCenterVO
	 * <p>
	 * @author yujian1
	 * @time 2016年6月4日 上午11:50:25
	 */
	public OrgCenterVO save(OrgCenterVO orgCenterVO,String orgId);
	
	public void saveBatch(List<OrgCenterVO> orgCenterList);
	
	
	/**
	 * 
	 * 方法功能描述：新增组织
	 * <b>参数说明</b>
	 * @param orgFunsId 职能id
	 * @param orgType 组织类型
	 * @param orgId 组织id
	 * @param pid 
	 * <p>
	 * @author yujian1
	 * @time 2016年6月4日 下午3:55:12
	 */
	public OrgCenterVO add(String orgFunsId,int orgType, String orgId,String pid);
	/**
	 * 
	 * 方法功能描述：查询获取最大的仅下级节点的innercode的后四位，为新增时拼接innercode做准备
	 * <b>参数说明</b>
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年4月25日 上午12:42:23
	 */
	public String getMaxInnercode(String id);
	
	
	/**
	 * 
	 * 方法功能描述：根据职能和组织id查询此组织所有的爹爹
	 * <b>参数说明</b>
	 * @param orgFunId
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年6月17日 下午2:47:22
	 */
	public List<String> queryAllParent(String orgFunId,String id);
	
	/**
	 * 方法功能描述：查询其所有的被停用的爹的数量
	 * <b>参数说明</b>
	 * @param orgFunId
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年6月17日 下午4:30:56
	 */
	public int countAllUnabledParent(String orgFunId, String id);
	
	/**
	 * 方法功能描述：查询其所有的被停用的爹的数量
	 * <b>参数说明</b>
	 * @param orgFunId
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年6月17日 下午4:30:56
	 */
	public List<OrgCenterVO> queryAllUnabledParent(String orgFunId, String id);
	
	/**
	 * 
	 * 方法功能描述：查询所有孩子
	 * <b>参数说明</b>
	 * @param orgFunId
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年6月17日 下午5:05:21
	 */
	public List<OrgCenterVO> queryAllChildren(String orgFunId, String orgId);
	
	public List<OrgCenterVO> queryAllChildrenByCompanyId(String orgFunId,String companyId);
	
	public List<OrgCenterVO> queryAllChildrenByCompanyId(String orgFunId,String companyId, String enabled);
	
	/**
	 * 历史接口（弃用）：依据CompanyFuncsEntity实体，初始化OrgCenterEntity实体，现在CompanyFuncsEntity已被移除
	 * @param id
	 * @return
	 */
	public List<OrgCenterVO> initTree(String id);
	public void saveData(OrgCenterTreeVo orgCenterTreeVo);
	public List<String> treeStates(String companyId,int type);
	//public List<String> updateTree(OrgCenterVO orgCenterVO);
	public void save(List<OrgCenterVO> list);
	/**
	 * 参照总页数
	 * @param searchText
	 * @param relyCondition
	 * @return
	 */
	public long refCount(String searchText, String relyCondition);
	/**
	 * 参照
	 * @param searchText
	 * @param relyCondition
	 * @param pageRequest
	 * @return
	 */
	public List<OrgCenterVO> refSearchOrgCenter(String searchText, String relyCondition, PageRequest pageRequest);
	
	/**
	 * 修改树级次。
	 * examples:
	 * 使用示例
	 * 参数说明
	 * @param orgCenterVO
	 * @param pid
	 * @return
	 * @author shl
	 * @time 2016年8月16日 上午7:50:50
	 */
	List<String> updateTree(OrgCenterVO orgCenterVO, String pid);
	
	/**
	 * 根据职能编码查组织职能树
	 * @param code
	 * @return
	 */
	public List<OrgCenterVO> getOrgsByCode(String code);
	
	public OrgCenterVO getOrgByCodeAndCompany(String code,String companyId);

	/**
	 * 获取上级职能组织对应的基础组织VO
	 * @param orgFunCode  职能组织编码
	 * @param companyId   基础组织id
	 * @return
	 */
	public CompanyVO getParentCompanyByOrgcenterVO (String orgFunCode, String companyId);
	
	/**
	 * 贵阳院组织部门数据推送
	 * 
	 * @param deptParams
	 * @return
	 */
	public String pushGyyEsbData(List<DeptParam> deptParams);

	public String getMaxInnercode(String parentId, String id);

	public String getParentId(String innercode, String funsId);

	public void updateOrgCenter(int isflag,String funsCode, String companyPid, String companyId);

	void delOrgByCompanyId(String companyId, String funcId);

	public void importOrgCenter( String funid, CompanyVO company);
	
	public List<OrgCenterVO> queryAllChildrenByCompanyId(String id);

	public List<OrgCenterVO> queryRootByFunId(String orgFunId);

	public List<OrgCenterVO> queryByFunIdAndCompanyId(String orgFunId, String id);
	
	public List<OrgCenterVO> queryByFunIdAndCompanyId(String orgFunId, String companyId, String enabled);

	/**
	 * 获取某职能组织的本下（默认获取启用状态的职能组织）
	 * @param orgFunId 职能信息主键
	 * @param orgId 职能组织主键
	 * @return
	 */
	public List<OrgCenterVO> queryNextChildren(String orgFunId, String orgId);
	
	/**
	 * 获取某职能组织的本息（根据给定的职能组织状态信息）
	 * @param orgFunCode 职能编码
	 * @param orgId 职能组织主键
	 * @param status 状态列表
	 * @return 下级职能组织列表{@link OrgCenterVO}
	 * @throws {@link BusinessException}
	 */
	public List<OrgCenterVO> queryNextChildren(String orgFunCode, String orgId, List<Integer> status) throws BusinessException;

	// add by gavin
	public void updateOrgCenter(String funsCode, String companyPid, String companyId);
	
	/**
	 * 职能组织与组织单元关联关系
	 * @param funsCode
	 * @param companyPid
	 * @param companyId
	 * @param orgUnitVO 组织单元内容
	 */
	public void updateOrgCenter(String funsCode, String companyPid, String companyId, CompanyVO orgUnitVO);
	
	/**
	 * 通过给定的条件condition获取到职能组织树
	 * @param condition 查询条件，包括：
	 *              funcCode：职能编码，例如法人code为0001
	 *              companyId:bd_company中组织ID
	 *              isOrgId:返回树的id是否为职能组织id（默认为基础组织id，1-返回职能组织id）
	 *              direction:上本下、本上、本下标识： 默认上本下，本上（up），本下（down） 当companyId有值时有效
	 *              billparams:职能组织过滤条件
	 * @return 职能组织树数据
	 */
	public String findFunOrgTree(JSONObject condition);
	
	/**
	 * 通过给定的条件condition获取到职能组织树(懒加载)
	 * @param condition 查询条件:
	 * 				String pid // 上级基础组织或者部门id
	 * 				String funcCode// 职能编码
	 * 				String root// 根组织
	 * @return 职能组织树数据
	 */
	public List<ExtReferTreeData> queryOrgsAndDeptsTreeLazy(String root, String pid, String funcCode);
	
	/**
	 * 职能组织迁移时，修改Pid职能组织所有下级组织的innercode
	 * @param pid
	 * @param innerCode
	 * @param funsCode 
	 */
	void repairOrgCenterInnerCode(String pid, String innerCode, String funsCode);
	
	/**
	 * 职能序列上级组织查询
	 * @param funcCode 职能编码
	 * @param companyId 基础组织ID
	 * @param tenantId 租户ID
	 * @return 上级职能组织信息，如果不存在返回null
	 */
	public OrgCenterVO getParentOrgCenter(String funcCode, String companyId, String tenantId);
	
	/**
	 * 获取组织具备的职能
	 * @param companyId
	 * @param tenantId
	 * @return
	 */
	public List<OrgCenterVO> getOrgCenterByCompanyId(String companyId, String tenantId);
	
	/**
	 * 获取组织具备的职能的编码
	 * @param companyId
	 * @param tenantId
	 * @return
	 */
	List<String> listOrgCodeByCompanyId(String companyId, String tenantId);
	/**
	 * 根据职能ID和组织ID删除当前职能组织及其下级
	 * @param orgFunsId
	 * @param companyId
	 */
	void delOrgCenterAndChildren(String orgFunsId, String companyId);
	
	/**
	 * 专门为参照0017编写，0017停用后可删除
	 * @return
	 */
	public List<OrgCenterVO> getOrgCenterByCompanyNameAndFunId(String companyName, String funId);
	
	// 从ICompanyFunService中复制过来的
	public void importSaveCompanyFunc(List<OrgFunsVo> list, CompanyVO company);
	
	/**
	 * 保存或更新基础组织变化的职能，即更新bd_org_center表
	 * @param companyFuncIds
	 * @param companyId
	 */
	public void saveOrgCenters(List<String> funcIds, String companyId);
	
	/**
	 * 上下调整职能组织显示顺序
	 * @param condition:顺序调整需要的参数
	 *  orgId：被调整的组织id
	 *  funcCode:职能code
	 *  up：上移标识，1上移，0下移
	 * @return
	 */
	public String moveOrg(JSONObject condition);
	// the end
	
	// 接口目的：对外暴露职能实体和bd_org_funs实体
	/**
	 * 对外提供dubbo 根据companyId获取其他职能
	 * @param companyId
	 * @return
	 */
	public RemarkColVO getRemarkColByCompany(String companyId);
	/**
	 * 对外提供dubbo 获取上下文对应租户下的所有职能信息 bd_org_funs实体数据
	 * @param companyId
	 * @return
	 */
	public List<OrgFunsVo> getAllOrgFuns();
	
	/**
	 * 校验bd_org_center表中innerCode是否正确
	 * @param funcCode
	 * @return
	 */
	List<OrgCenterVO> getInnerCodeNull(String funcCode);
	// the end
	
	/**
	 * 根据组织单元和职能类型编码，返回该职能的上级行政组织主键
	 * @param orgUnitId 组织单元主键
	 * @param orgType 职能类型编码
	 * @param layer 层级 0-本级 1-上一级 2-上两级 以此类推
	 * @return 上级行政组织主键（如果该职能没有行政组织则返回null）
	 * @throws BusinessException （如果层级大于最大层级，抛出该异常）
	 */
	String getParentAdminId(String orgUnitId, String orgType, int layer, String tenantId) throws BusinessException;
}
