package com.yyjz.icop.orgcenter.orgsystem.service;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.yyjz.icop.base.exception.BusinessException;

/**
 * 组织体系分类基本服务
 * 
 * @author GavinWood
 */
public interface BaseOrgSystemService<V>{
	/********************************************************************************
	 ********************************** 组织体系分类 读 ***********************************
	 ********************************************************************************/
	
	/**
	 * 获取详情
	 * @param id
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	V getById(String id) throws BusinessException;
	
	/**
	 * 获取详情
	 * @param id
	 * @param tenant_id
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	V getByIdIgnoreDr(String id) throws BusinessException;
	
	/**
	 * 获取列表
	 * @param ids
	 * @param status
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	List<V> getByIds(List<String> ids, List<Integer> status) throws BusinessException;
	
	/**
	 * 获取详情
	 * @param code
	 * @param status
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	V getByCode(String code, String tenantId) throws BusinessException;
	
	/**
	 * 获取列表
	 * @param name
	 * @param status
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	List<V> getByName(String name, List<Integer> status, String tenantId) throws BusinessException;
	
	/**
	 * 获取列表
	 * @param status
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	List<V> getByEnabled(List<Integer> status, String tenantId) throws BusinessException;
	
	/**
	 * 获取列表
	 * @param status
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	List<V> list(List<Integer> status, String tenantId) throws BusinessException;
	
	/**
	 * 分页
	 * @param keyword
	 * @param pageable
	 * @param tenantId
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	Page<V> page(String keyword, Pageable pageable, String tenantId, String condition) throws BusinessException;
	
	/********************************************************************************
	 ********************************** 组织体系分类 写 ***********************************
	 ********************************************************************************/
	/**
	 * 保存/更新实体
	 * @param vo
	 * @param tenantId
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	V save(V vo) throws BusinessException;
	
	/**
	 * 保存/更新实体
	 * @param vos
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	List<V> save(List<V> vos) throws BusinessException;
	
	/**
	 * 删除实体
	 * @param vo
	 * @param tenantId
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	V del(String id) throws BusinessException;
	
	/**
	 * 批量删除实体
	 * @param vo
	 * @param tenantId
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	List<V> del(List<String> ids) throws BusinessException;
	
	/**
	 * 启用
	 * @param id
	 * @param status 
	 * @param tenantId
	 * @return true-成功 false-失败
	 * @throws BusinessException
	 */
	boolean enable(String id, int status, String tenantId) throws BusinessException;
	
	/**
	 * 启用<批量>
	 * @param id
	 * @param status
	 * @param tenantId
	 * @return true-成功 false-失败
	 * @throws BusinessException
	 */
	boolean enable(List<String> ids, int status, String tenantId) throws BusinessException;
	
	/**
	 * 停用
	 * @param id
	 * @param status 
	 * @param tenantId
	 * @return true-成功 false-失败
	 * @throws BusinessException
	 */
	boolean disable(String id, int status, String tenantId) throws BusinessException;
	
	/**
	 * 停用<批量>
	 * @param id
	 * @param status
	 * @param tenantId
	 * @return true-成功 false-失败
	 * @throws BusinessException
	 */
	boolean disable(List<String> ids, int status, String tenantId) throws BusinessException;
	
	/**
	 * 同层次间迁移<批量>
	 * @param sourceId
	 * @param targetId
	 * @param tenantId
	 * @return true-成功 false-失败
	 * @throws BusinessException
	 */
	boolean move(String sourceId, String targetId, String tenantId) throws BusinessException;
}
